/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.accounting.model.print;

import java.math.BigDecimal;
import java.util.Date;
import java.util.function.Supplier;
import javax.persistence.Entity;
import org.springframework.util.Assert;
import pl.matsuo.accounting.model.cashregister.CashRegister;
import pl.matsuo.accounting.model.cashregister.CashRegisterReport;
import pl.matsuo.accounting.model.print.AccountingPrintStatus;
import pl.matsuo.core.model.print.IPrintFacade;
import pl.matsuo.core.model.print.KeyValuePrint;
import pl.matsuo.core.model.validation.EntityReference;

@Entity
public class AccountingPrint
extends KeyValuePrint {
    @EntityReference(value=CashRegister.class)
    private Integer idCashRegister;
    @EntityReference(value=CashRegisterReport.class)
    private Integer idCashRegisterReport;
    private AccountingPrintStatus status = AccountingPrintStatus.OPEN;
    private Date issuanceDate;
    private Date dueDate;
    private Date sellDate;
    private BigDecimal value;
    private BigDecimal cashRegisterAmount;
    private BigDecimal totalAmount;

    public static Supplier<? extends AccountingPrint> print(Class<? extends IPrintFacade> clazz, Integer id) {
        return () -> (AccountingPrint)((Object)((Object)AccountingPrint.printInitializer((Class)clazz, (Integer)id).apply(new AccountingPrint())));
    }

    public boolean isCost() {
        Assert.notNull((Object)this.getIdBucket());
        return !((String)this.getFields().get("seller.id")).equals("" + this.getIdBucket());
    }

    public BigDecimal getCashRegisterAmount() {
        return this.isCost() ? this.getValue().negate() : this.getValue();
    }

    public void setValue(BigDecimal value) {
        this.value = value;
        this.cashRegisterAmount = this.isCost() ? value.negate() : value;
    }

    public Integer getIdCashRegister() {
        return this.idCashRegister;
    }

    public void setIdCashRegister(Integer idCashRegister) {
        this.idCashRegister = idCashRegister;
    }

    public Integer getIdCashRegisterReport() {
        return this.idCashRegisterReport;
    }

    public void setIdCashRegisterReport(Integer idCashRegisterReport) {
        this.idCashRegisterReport = idCashRegisterReport;
    }

    public AccountingPrintStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountingPrintStatus status) {
        this.status = status;
    }

    public Date getIssuanceDate() {
        return this.issuanceDate;
    }

    public void setIssuanceDate(Date issuanceDate) {
        this.issuanceDate = issuanceDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getSellDate() {
        return this.sellDate;
    }

    public void setSellDate(Date sellDate) {
        this.sellDate = sellDate;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getValue() {
        return this.value;
    }
}

