/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.accounting.web.controller.print;

import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import pl.matsuo.accounting.model.print.AccountingPrint;
import pl.matsuo.accounting.model.print.CashDocument;
import pl.matsuo.accounting.service.print.ICashDocumentService;
import pl.matsuo.accounting.web.controller.print.ICashDocumentParams;
import pl.matsuo.core.exception.RestProcessingException;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.query.AbstractQuery;
import pl.matsuo.core.model.query.QueryBuilder;
import pl.matsuo.core.model.query.condition.Condition;
import pl.matsuo.core.params.IQueryRequestParams;
import pl.matsuo.core.web.controller.print.AbstractPrintController;

@RestController
@RequestMapping(value={"/cashDocuments"})
public class CashDocumentController
extends AbstractPrintController<CashDocument, AccountingPrint, ICashDocumentParams> {
    @Autowired
    ICashDocumentService[] cashDocumentServices;

    protected ICashDocumentService findCashDocumentService(String printType) {
        for (ICashDocumentService cashDocumentService : this.cashDocumentServices) {
            if (!cashDocumentService.printType().getSimpleName().toLowerCase().equals(printType.toLowerCase())) continue;
            return cashDocumentService;
        }
        throw new RestProcessingException(new String[]{"Unable to process print type: " + printType});
    }

    protected AbstractQuery<AccountingPrint> listQuery(ICashDocumentParams params, Condition ... additionalConditions) {
        return super.listQuery((IQueryRequestParams)params, new Condition[]{QueryBuilder.maybe((Object)params.getStartDate(), (Condition)QueryBuilder.ge(AccountingPrint::getIssuanceDate, (Object)params.getStartDate())), QueryBuilder.maybe((Object)params.getEndDate(), (Condition)QueryBuilder.le(AccountingPrint::getIssuanceDate, (Object)params.getEndDate()))}).orderBy("issuanceDate DESC");
    }

    @RequestMapping(value={"/{printType}"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public HttpEntity<AccountingPrint> create(@PathVariable(value="printType") String printType, @RequestBody AccountingPrint entity, @Value(value="#{request.requestURL}") StringBuffer parentUri) {
        entity.setIdBucket(this.sessionState.getIdBucket());
        this.findCashDocumentService(printType).create(entity);
        return super.create((AbstractEntity)entity, parentUri);
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public HttpEntity<AccountingPrint> create(@RequestBody AccountingPrint entity, @Value(value="#{request.requestURL}") StringBuffer parentUri) {
        entity.setIdBucket(this.sessionState.getIdBucket());
        this.findCashDocumentService(entity.getPrintClass().getSimpleName()).create(entity);
        return super.create((AbstractEntity)entity, parentUri);
    }

    @RequestMapping(method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void update(@RequestBody @Valid AccountingPrint entity) {
        super.update((AbstractEntity)this.findCashDocumentService(entity.getPrintClass().getSimpleName()).update(entity));
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void update(@PathVariable(value="id") Integer id, @RequestBody AccountingPrint entity) {
        super.update(id, (AbstractEntity)this.findCashDocumentService(entity.getPrintClass().getSimpleName()).update(entity));
    }
}

