/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.accounting.web.controller.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import pl.matsuo.accounting.model.cashregister.CashRegister;
import pl.matsuo.accounting.model.cashregister.CashRegisterReport;
import pl.matsuo.accounting.model.cashregister.initializer.CashRegisterReportInitializer;
import pl.matsuo.accounting.model.print.AccountingPrint;
import pl.matsuo.accounting.model.print.CashDocumentUtil;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.api.Initializer;
import pl.matsuo.core.model.print.initializer.PrintInitializer;
import pl.matsuo.core.model.query.Query;
import pl.matsuo.core.model.query.QueryBuilder;
import pl.matsuo.core.model.query.condition.QueryPart;
import pl.matsuo.core.params.IQueryRequestParams;
import pl.matsuo.core.util.StringUtil;
import pl.matsuo.core.web.controller.AbstractController;

@RestController
@RequestMapping(value={"/cashRegisterReports"})
public class CashRegisterReportController
extends AbstractController<CashRegisterReport, ICashRegisterReportControllerQueryRequestParams> {
    protected List<? extends Initializer<CashRegisterReport>> entityInitializers() {
        return Arrays.asList(new CashRegisterReportInitializer());
    }

    @RequestMapping(method={RequestMethod.GET})
    public List<CashRegisterReport> list(ICashRegisterReportControllerQueryRequestParams params) {
        List list = super.list((IQueryRequestParams)params);
        if (StringUtil.notEmpty((String)params.getLast())) {
            HashMap<CashRegister, CashRegisterReport> reports = new HashMap<CashRegister, CashRegisterReport>();
            for (CashRegisterReport report : list) {
                if (reports.get(report.getCashRegister()) != null && ((CashRegisterReport)reports.get(report.getCashRegister())).getCreatedTime().compareTo(report.getCreatedTime()) >= 0) continue;
                reports.put(report.getCashRegister(), report);
            }
            return new ArrayList<CashRegisterReport>(reports.values());
        }
        return list;
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public HttpEntity<CashRegisterReport> create(@RequestBody @Valid CashRegisterReport entity, @Value(value="#{request.requestURL}") StringBuffer parentUri) {
        CashRegisterReport report = this.reportForCashRegister(entity.getCashRegister().getId());
        HttpEntity httpEntity = super.create((AbstractEntity)report, parentUri);
        return httpEntity;
    }

    @RequestMapping(value={"/reportForCashRegister/{id}"}, method={RequestMethod.GET}, consumes={"application/octet-stream"})
    public CashRegisterReport reportForCashRegister(@PathVariable(value="id") Integer idCashRegister) {
        CashRegister cashRegister = (CashRegister)this.database.findOne((Query)QueryBuilder.query(CashRegister.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq(AbstractEntity::getId, (Object)idCashRegister)}));
        CashRegisterReport lastReport = (CashRegisterReport)this.database.findOne((Query)QueryBuilder.query(CashRegisterReport.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq((Function)QueryBuilder.sub(CashRegisterReport::getCashRegister, AbstractEntity::getId), (Object)idCashRegister)}).orderBy("createdTime DESC").limit(Integer.valueOf(1)));
        List prints = this.database.find((Query)QueryBuilder.query(AccountingPrint.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq(AccountingPrint::getIdCashRegister, (Object)idCashRegister), QueryBuilder.isNull(AccountingPrint::getIdCashRegisterReport)}).initializer(new Initializer[]{new PrintInitializer()}));
        CashRegisterReport report = new CashRegisterReport();
        report.setCreatedTime(new Date());
        report.setCashRegister(cashRegister);
        report.getPrints().addAll(prints);
        report.setStartingBalance(lastReport != null ? lastReport.getEndingBalance() : BigDecimal.ZERO);
        report.setEndingBalance(lastReport != null ? lastReport.getEndingBalance() : BigDecimal.ZERO);
        report.setEndingBalance(report.getEndingBalance().add(CashDocumentUtil.sumCashRegisterAmount((List)prints)));
        return report;
    }

    @RequestMapping(value={"/cashRegisterPrintsSummary/{id}"}, method={RequestMethod.GET}, consumes={"application/octet-stream"})
    public BigDecimal cashRegisterPrintsSummary(@PathVariable(value="id") Integer idCashRegister) {
        return CashDocumentUtil.sumCashRegisterAmount((List)this.database.find((Query)QueryBuilder.query(AccountingPrint.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq(AccountingPrint::getIdCashRegister, (Object)idCashRegister), QueryBuilder.isNull(AccountingPrint::getIdCashRegisterReport)}).initializer(new Initializer[]{new PrintInitializer()})));
    }

    public static interface ICashRegisterReportControllerQueryRequestParams
    extends IQueryRequestParams {
        public String getLast();
    }
}

