/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.interfacer;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ClassLoaderTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.utils.CodeGenerationUtils;
import com.github.javaparser.utils.Log;
import com.github.javaparser.utils.SourceRoot;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import pl.matsuo.interfacer.IfcResolve;
import pl.matsuo.interfacer.JavaParserMavenUtils;
import pl.matsuo.interfacer.TypeWithName;

@Mojo(name="add-interfaces", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class InterfacerPluginMojo
extends AbstractMojo {
    @Parameter
    String interfacePackage;
    @Parameter(required=true)
    File interfacesDirectory;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-sources/avro")
    File scanDirectory;
    @Parameter(property="project", required=true, readonly=true)
    MavenProject project;

    public void execute() throws MojoExecutionException {
        JavaParserMavenUtils.makeJavaParserLogToMavenOutput(this.getLog());
        this.addInterfacesAllFiles(this.scanDirectory);
    }

    private List<IfcResolve> scanInterfacesFromSrc(ParserConfiguration parserConfiguration) throws MojoExecutionException {
        ArrayList<IfcResolve> ifcs = new ArrayList<IfcResolve>();
        SourceRoot source = new SourceRoot(this.interfacesDirectory.toPath(), parserConfiguration);
        try {
            for (ParseResult parseResult : source.tryToParse()) {
                if (!parseResult.isSuccessful()) continue;
                parseResult.getResult().ifPresent(cu -> {
                    IfcResolve ifcResolve = this.getIfcResolve((CompilationUnit)cu);
                    if (ifcResolve != null) {
                        ifcs.add(ifcResolve);
                    }
                });
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading from source directory", (Exception)e);
        }
        return ifcs;
    }

    private IfcResolve getIfcResolve(CompilationUnit cu) {
        return cu.getPrimaryType().filter(BodyDeclaration::isClassOrInterfaceDeclaration).map(type -> (ClassOrInterfaceDeclaration)type).filter(ClassOrInterfaceDeclaration::isInterface).map(type -> {
            this.getLog().info((CharSequence)("Adding interface: " + type.getNameAsString()));
            IfcResolve ifcResolve = new IfcResolve(cu.getPackageDeclaration().map(packageDeclaration -> packageDeclaration.getNameAsString() + ".").orElse("") + type.getNameAsString(), type.resolve(), null);
            type.resolve().getAllMethods().forEach(method -> {
                ResolvedMethodDeclaration methodDeclaration = method.getDeclaration();
                if (methodDeclaration.getNumberOfParams() == 0 && methodDeclaration.getName().startsWith("get") && !methodDeclaration.getName().equals("getClass")) {
                    this.getLog().info((CharSequence)("Adding method: " + methodDeclaration));
                    ifcResolve.methods.add(new TypeWithName(methodDeclaration.getName(), methodDeclaration.getReturnType(), null));
                }
            });
            type.getMethods().forEach(methodDeclaration -> {});
            return ifcResolve;
        }).orElse(null);
    }

    private List<IfcResolve> scanInterfacesFromClasspath(ClassLoader classLoader) {
        if (this.interfacePackage == null) {
            return Collections.emptyList();
        }
        String[] interfacePackages = this.interfacePackage.split(",");
        Reflections reflections = this.createReflections(classLoader, interfacePackages);
        ArrayList<IfcResolve> ifcs = new ArrayList<IfcResolve>();
        reflections.getSubTypesOf(Object.class).forEach(type -> this.processClassFromClasspath((List<IfcResolve>)ifcs, (Class<?>)type));
        return ifcs;
    }

    private void processClassFromClasspath(List<IfcResolve> ifcs, Class<?> type) {
        this.getLog().info((CharSequence)("Processing classpath type: " + type.getCanonicalName()));
        if (type.isInterface()) {
            this.getLog().info((CharSequence)("Adding interface: " + type.getName()));
            IfcResolve ifcResolve = new IfcResolve(type.getName(), null, type);
            for (Method method : type.getMethods()) {
                if (method.getParameterCount() != 0 || !method.getName().startsWith("get")) continue;
                this.getLog().info((CharSequence)("Adding method: " + method.toString()));
                ifcResolve.methods.add(new TypeWithName(method.getName(), null, method.getReturnType()));
            }
            ifcs.add(ifcResolve);
        }
    }

    private Reflections createReflections(ClassLoader classLoader, String[] interfacePackages) {
        return new Reflections((Configuration)new ConfigurationBuilder().addClassLoader(classLoader).setUrls(ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{classLoader})).setScanners(new Scanner[]{new SubTypesScanner(false)}).filterInputsBy((Predicate)new FilterBuilder().includePackage(interfacePackages)));
    }

    private ClassLoader getCompileClassLoader() throws MojoExecutionException {
        try {
            List compileClasspathElements = this.project.getCompileClasspathElements();
            List<URL> jars = compileClasspathElements.stream().filter(name -> name.endsWith(".jar")).map(this::toUrl).collect(Collectors.toList());
            jars.forEach(element -> this.getLog().info((CharSequence)("Compile classloader entry: " + element)));
            URLClassLoader classLoader = new URLClassLoader(jars.toArray(new URL[0]));
            return classLoader;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("DependencyResolutionRequiredException", (Exception)((Object)e));
        }
    }

    private URL toUrl(String name) {
        try {
            return new File(name).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void addInterfacesAllFiles(File scanDirectory) throws MojoExecutionException {
        try {
            AtomicBoolean modified = new AtomicBoolean(true);
            while (modified.get()) {
                modified.set(false);
                ClassLoader classLoader = this.getCompileClassLoader();
                CombinedTypeSolver combinedTypeSolver = this.createTypeSolver(scanDirectory, classLoader);
                ParserConfiguration parserConfiguration = new ParserConfiguration();
                parserConfiguration.setSymbolResolver((SymbolResolver)new JavaSymbolSolver((TypeSolver)combinedTypeSolver));
                SourceRoot source = new SourceRoot(scanDirectory.toPath(), parserConfiguration);
                ArrayList<IfcResolve> ifcs = new ArrayList<IfcResolve>();
                ifcs.addAll(this.scanInterfacesFromClasspath(classLoader));
                ifcs.addAll(this.scanInterfacesFromSrc(parserConfiguration));
                Comparator<IfcResolve> comparator = Comparator.comparing(i -> -i.methods.size());
                ifcs.sort(comparator);
                for (ParseResult parseResult : source.tryToParse()) {
                    if (!parseResult.isSuccessful()) continue;
                    parseResult.getResult().ifPresent(cu -> {
                        cu.getStorage().ifPresent(storage -> Log.info((String)CodeGenerationUtils.f((String)"Processing %s...", (Object[])new Object[]{storage.getFileName()}), (Supplier[])new Supplier[0]));
                        boolean modifiedState = this.addInterfaces((CompilationUnit)cu, (List<IfcResolve>)ifcs, combinedTypeSolver);
                        modified.set(modified.get() || modifiedState);
                    });
                }
                source.saveAll();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading from source directory", (Exception)e);
        }
    }

    private CombinedTypeSolver createTypeSolver(File scanDirectory, ClassLoader classLoader) {
        CombinedTypeSolver combinedTypeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        combinedTypeSolver.add((TypeSolver)new ClassLoaderTypeSolver(classLoader){});
        combinedTypeSolver.add((TypeSolver)new JavaParserTypeSolver(scanDirectory.toPath()));
        combinedTypeSolver.add((TypeSolver)new JavaParserTypeSolver(this.interfacesDirectory.toPath()));
        return combinedTypeSolver;
    }

    private boolean addInterfaces(CompilationUnit compilationUnit, List<IfcResolve> ifcs, CombinedTypeSolver combinedTypeSolver) {
        AtomicBoolean modified = new AtomicBoolean();
        compilationUnit.getPrimaryType().map(primaryType -> primaryType.isClassOrInterfaceDeclaration() ? (ClassOrInterfaceDeclaration)primaryType : null).filter(declaration -> !declaration.isInterface()).ifPresent(declaration -> ifcs.forEach(ifc -> this.processDeclarationWithInterface(combinedTypeSolver, modified, (ClassOrInterfaceDeclaration)declaration, (IfcResolve)ifc)));
        return modified.get();
    }

    private void processDeclarationWithInterface(CombinedTypeSolver combinedTypeSolver, AtomicBoolean modified, ClassOrInterfaceDeclaration declaration, IfcResolve ifc) {
        int matchingMethods = 0;
        for (TypeWithName methodDecl : ifc.methods) {
            boolean found = declaration.getMethodsBySignature(methodDecl.name, new String[0]).stream().anyMatch(method -> {
                if (methodDecl.resolvedType != null) {
                    return methodDecl.resolvedType.isAssignableBy(method.getType().resolve());
                }
                ReflectionInterfaceDeclaration resolvedReferenceTypeDeclaration = methodDecl.clazz.isInterface() ? new ReflectionInterfaceDeclaration(methodDecl.clazz, (TypeSolver)combinedTypeSolver) : new ReflectionClassDeclaration(methodDecl.clazz, (TypeSolver)combinedTypeSolver);
                return resolvedReferenceTypeDeclaration.isAssignableBy(method.getType().resolve());
            });
            if (found) {
                ++matchingMethods;
                continue;
            }
            this.getLog().info((CharSequence)("Missing method " + methodDecl.name));
            return;
        }
        this.getLog().info((CharSequence)("Processing declaration " + declaration.getFullyQualifiedName() + " with ifc " + ifc.name));
        ResolvedReferenceTypeDeclaration other = ifc.resolve != null ? ifc.resolve : new ReflectionInterfaceDeclaration(ifc.clazz, (TypeSolver)combinedTypeSolver);
        boolean canBeAssignedTo = declaration.resolve().getAncestors().stream().anyMatch(ancestor -> other.isAssignableBy((ResolvedType)ancestor));
        if (matchingMethods > 0 && !canBeAssignedTo) {
            this.getLog().info((CharSequence)"Modifying the class!");
            declaration.addImplementedType(ifc.name);
            modified.set(true);
        }
    }
}

