/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.util;

import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import pl.matsuo.core.util.DateUtil;

public class TestDateUtil {
    @Test
    public void testDate() {
        Assert.assertEquals((long)1398170096789L, (long)DateUtil.date((String)"2014-04-22T12:34:56.789Z").getTime());
        Assert.assertEquals((long)1398170096000L, (long)DateUtil.date((String)"2014-04-22T12:34:56Z").getTime());
        Assert.assertEquals((long)1398170096789L, (long)DateUtil.date((String)"\"2014-04-22T12:34:56.789Z\"").getTime());
        Assert.assertEquals((long)1398170096789L, (long)DateUtil.date((String)"1398170096789").getTime());
    }

    @Test
    public void testIsoFormat() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(1398170096789L);
        Assert.assertEquals((Object)"2014-04-22T12:34:56Z", (Object)DateUtil.isoFormat((Date)cal.getTime()));
    }

    @Test
    public void testDate1() {
        Date date = DateUtil.date((Date)new Date(100, 1, 2), (Integer)10, (Integer)20);
        Assert.assertEquals((long)100L, (long)date.getYear());
        Assert.assertEquals((long)1L, (long)date.getMonth());
        Assert.assertEquals((long)2L, (long)date.getDate());
        Assert.assertEquals((long)10L, (long)date.getHours());
        Assert.assertEquals((long)20L, (long)date.getMinutes());
    }

    @Test
    public void testDate2() {
        Date date = DateUtil.date((int)2020, (int)1, (int)2);
        Assert.assertEquals((long)120L, (long)date.getYear());
        Assert.assertEquals((long)1L, (long)date.getMonth());
        Assert.assertEquals((long)2L, (long)date.getDate());
        Assert.assertEquals((long)0L, (long)date.getHours());
        Assert.assertEquals((long)0L, (long)date.getMinutes());
    }

    @Test
    public void testMaybeDate() {
        Assert.assertNull((Object)DateUtil.maybeDate((String)"test"));
        Assert.assertNotNull((Object)DateUtil.maybeDate((String)"2020-01-02T15:19:21+00:00"));
    }

    @Test
    public void testDate3() {
        Date date = DateUtil.date((int)2020, (int)1, (int)2, (int)8, (int)25);
        Assert.assertEquals((long)120L, (long)date.getYear());
        Assert.assertEquals((long)1L, (long)date.getMonth());
        Assert.assertEquals((long)2L, (long)date.getDate());
        Assert.assertEquals((long)8L, (long)date.getHours());
        Assert.assertEquals((long)25L, (long)date.getMinutes());
    }

    @Test
    public void testDate4() {
        Date date = DateUtil.date((String)"2020-01-02T15:19:21+00:00");
        Assert.assertEquals((long)120L, (long)date.getYear());
        Assert.assertEquals((long)0L, (long)date.getMonth());
        Assert.assertEquals((long)2L, (long)date.getDate());
        Assert.assertEquals((long)19L, (long)date.getMinutes());
    }

    @Test
    public void testAddTime() {
        Date date = DateUtil.addTime((Date)DateUtil.date((int)2000, (int)7, (int)10), (int)12, (int)17);
        Assert.assertEquals((long)0L, (long)date.getHours());
        Assert.assertEquals((long)17L, (long)date.getMinutes());
    }

    @Test
    public void testCal() {
        Calendar cal = DateUtil.cal((int)2015, (int)4, (int)22, (int)10, (int)20);
        Assert.assertEquals((long)2015L, (long)cal.get(1));
        Assert.assertEquals((long)4L, (long)cal.get(2));
        Assert.assertEquals((long)22L, (long)cal.get(5));
        Assert.assertEquals((long)10L, (long)cal.get(10));
        Assert.assertEquals((long)20L, (long)cal.get(12));
    }

    @Test
    public void testCal1() {
        Calendar cal = DateUtil.cal((int)2015, (int)4, (int)22);
        Assert.assertEquals((long)2015L, (long)cal.get(1));
        Assert.assertEquals((long)4L, (long)cal.get(2));
        Assert.assertEquals((long)22L, (long)cal.get(5));
        Assert.assertEquals((long)0L, (long)cal.get(10));
        Assert.assertEquals((long)0L, (long)cal.get(12));
    }

    @Test
    public void testCal2() {
        Calendar cal = DateUtil.cal((Date)DateUtil.date((int)2015, (int)4, (int)22, (int)10, (int)20));
        Assert.assertEquals((long)2015L, (long)cal.get(1));
        Assert.assertEquals((long)4L, (long)cal.get(2));
        Assert.assertEquals((long)22L, (long)cal.get(5));
        Assert.assertEquals((long)10L, (long)cal.get(10));
        Assert.assertEquals((long)20L, (long)cal.get(12));
    }

    @Test
    public void testCal3() {
        Calendar cal = DateUtil.cal((long)DateUtil.date((int)2015, (int)4, (int)22, (int)10, (int)20).getTime());
        Assert.assertEquals((long)2015L, (long)cal.get(1));
        Assert.assertEquals((long)4L, (long)cal.get(2));
        Assert.assertEquals((long)22L, (long)cal.get(5));
        Assert.assertEquals((long)10L, (long)cal.get(10));
        Assert.assertEquals((long)20L, (long)cal.get(12));
    }

    @Test
    public void testCal4() {
        Calendar cal = DateUtil.cal((Date)DateUtil.date((int)2015, (int)4, (int)22), (Integer)10, (Integer)20);
        Assert.assertEquals((long)2015L, (long)cal.get(1));
        Assert.assertEquals((long)4L, (long)cal.get(2));
        Assert.assertEquals((long)22L, (long)cal.get(5));
        Assert.assertEquals((long)10L, (long)cal.get(10));
        Assert.assertEquals((long)20L, (long)cal.get(12));
    }

    @Test
    public void testTime() {
        Time time = DateUtil.time((int)10, (int)20);
        Assert.assertEquals((long)10L, (long)time.getHours());
        Assert.assertEquals((long)20L, (long)time.getMinutes());
    }

    @Test
    public void testDateAndTime() {
        Date date = DateUtil.dateAndTime((Date)DateUtil.date((int)2015, (int)4, (int)22), (Time)DateUtil.time((int)10, (int)20));
        Assert.assertEquals((long)115L, (long)date.getYear());
        Assert.assertEquals((long)4L, (long)date.getMonth());
        Assert.assertEquals((long)22L, (long)date.getDate());
        Assert.assertEquals((long)10L, (long)date.getHours());
        Assert.assertEquals((long)20L, (long)date.getMinutes());
    }

    @Test
    public void testMin() {
        Assert.assertEquals((Object)DateUtil.date((int)2014, (int)7, (int)12), (Object)DateUtil.min((Date)DateUtil.date((int)2015, (int)1, (int)7), (Date)DateUtil.date((int)2014, (int)7, (int)12)));
    }

    @Test
    public void testMax() {
        Assert.assertEquals((Object)DateUtil.date((int)2015, (int)1, (int)7), (Object)DateUtil.max((Date)DateUtil.date((int)2015, (int)1, (int)7), (Date)DateUtil.date((int)2014, (int)7, (int)12)));
    }

    @Test
    public void testMin1() {
        Assert.assertEquals((Object)DateUtil.cal((int)2014, (int)7, (int)12), (Object)DateUtil.min((Calendar)DateUtil.cal((int)2015, (int)1, (int)7), (Calendar)DateUtil.cal((int)2014, (int)7, (int)12)));
    }

    @Test
    public void testMax1() {
        Assert.assertEquals((Object)DateUtil.cal((int)2015, (int)1, (int)7), (Object)DateUtil.max((Calendar)DateUtil.cal((int)2015, (int)1, (int)7), (Calendar)DateUtil.cal((int)2014, (int)7, (int)12)));
    }

    @Test
    public void testBetween() {
        Assert.assertTrue((boolean)DateUtil.between((Date)DateUtil.date((int)2014, (int)9, (int)12), (Date)DateUtil.date((int)2014, (int)7, (int)12), (Date)DateUtil.date((int)2015, (int)1, (int)7)));
        Assert.assertFalse((boolean)DateUtil.between((Date)DateUtil.date((int)2012, (int)9, (int)12), (Date)DateUtil.date((int)2014, (int)7, (int)12), (Date)DateUtil.date((int)2015, (int)1, (int)7)));
    }

    @Test
    public void testSqlDate() {
    }

    @Test
    public void testSqlDate1() {
    }

    @Test
    public void testSqlDate2() {
    }

    @Test
    public void testSqlDate3() {
    }

    @Test
    public void testIsoFormat1() {
    }

    @Test
    public void testLocalDate() {
    }

    @Test
    public void testGetQuaterStart() {
        Assert.assertEquals((Object)DateUtil.date((int)2014, (int)0, (int)1), (Object)DateUtil.getQuaterStart((Date)DateUtil.date((int)2014, (int)0, (int)15)));
        Assert.assertEquals((Object)DateUtil.date((int)2014, (int)0, (int)1), (Object)DateUtil.getQuaterStart((Date)DateUtil.date((int)2014, (int)2, (int)30)));
        Assert.assertEquals((Object)DateUtil.date((int)2014, (int)3, (int)1), (Object)DateUtil.getQuaterStart((Date)DateUtil.date((int)2014, (int)4, (int)15)));
        Assert.assertEquals((Object)DateUtil.date((int)2014, (int)6, (int)1), (Object)DateUtil.getQuaterStart((Date)DateUtil.date((int)2014, (int)8, (int)30)));
        Assert.assertEquals((Object)DateUtil.date((int)2014, (int)9, (int)1), (Object)DateUtil.getQuaterStart((Date)DateUtil.date((int)2014, (int)11, (int)31)));
    }

    @Test
    public void testGetQuaterEnd() {
        Assert.assertEquals((Object)DateUtil.date((int)2014, (int)2, (int)31), (Object)DateUtil.getQuaterEnd((Date)DateUtil.date((int)2014, (int)0, (int)15)));
        Assert.assertEquals((Object)DateUtil.date((int)2014, (int)2, (int)31), (Object)DateUtil.getQuaterEnd((Date)DateUtil.date((int)2014, (int)2, (int)30)));
        Assert.assertEquals((Object)DateUtil.date((int)2014, (int)5, (int)30), (Object)DateUtil.getQuaterEnd((Date)DateUtil.date((int)2014, (int)4, (int)15)));
        Assert.assertEquals((Object)DateUtil.date((int)2014, (int)8, (int)30), (Object)DateUtil.getQuaterEnd((Date)DateUtil.date((int)2014, (int)8, (int)30)));
        Assert.assertEquals((Object)DateUtil.date((int)2014, (int)11, (int)31), (Object)DateUtil.getQuaterEnd((Date)DateUtil.date((int)2014, (int)11, (int)31)));
    }
}

