/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.util;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import pl.matsuo.core.util.ReflectUtil;

public class TestReflectUtil {
    @Test
    public void testResolveType() {
        Assert.assertEquals(Integer.class, (Object)ReflectUtil.resolveType(new ArrayList<Integer>(){}.getClass(), List.class, (int)0));
    }

    @Test
    public void testGetValue() {
        Assert.assertEquals((Object)"test X", (Object)ReflectUtil.getValue((Object)new X(), (String)"fieldValue"));
        Assert.assertEquals((Object)"test X2", (Object)ReflectUtil.getValue((Object)new X(), (String)"methodValue"));
        Assert.assertEquals((Object)"error", (Object)ReflectUtil.getValue((Object)new Y(), (String)"fieldValue"));
        Assert.assertEquals((Object)"error 2", (Object)ReflectUtil.getValue((Object)new Y(), (String)"methodValue"));
        Assert.assertEquals((Object)"test Y", (Object)ReflectUtil.getValue((Object)new Y(), (String)"fieldValue2"));
        Assert.assertEquals((Object)"test Y2", (Object)ReflectUtil.getValue((Object)new Y(), (String)"methodValue2"));
    }

    @Test
    public void testGetValue1() {
        Assert.assertEquals((Object)"test X", (Object)ReflectUtil.getValue((Object)new Y(), (String)"fieldValue", X.class).get());
        Assert.assertEquals((Object)"test X2", (Object)ReflectUtil.getValue((Object)new Y(), (String)"methodValue", X.class).get());
    }

    @Test
    public void testGetExactPropertyType() {
        Assert.assertEquals(String.class, (Object)ReflectUtil.getExactPropertyType(X.class, (String)"fieldValue"));
    }

    @Test
    public void testGetExactPropertyType1() {
        Assert.assertEquals(String.class, (Object)ReflectUtil.getExactPropertyType(Arrays.asList(X.class), (String)"fieldValue"));
    }

    @Test
    public void testGetPropertyType() {
        Assert.assertEquals(String.class, (Object)ReflectUtil.getPropertyType(Z.class, (String)"complex.fieldValue"));
        Assert.assertEquals(Z.class, (Object)ReflectUtil.getPropertyType(Z.class, (String)"complex.complex"));
    }

    @Test(expected=RuntimeException.class)
    public void testGetPropertyType1() {
        Assert.assertEquals(Z.class, (Object)ReflectUtil.getPropertyType(Z.class, (String)"xxx"));
    }

    @Test(expected=RuntimeException.class)
    public void testGetPropertyType2() {
        Assert.assertEquals(Z.class, (Object)ReflectUtil.getPropertyType(Z.class, (String)"xxx.xxx"));
    }

    @Test
    public void testGetExactAnnotatedElement() {
        AnnotatedElement complex = ReflectUtil.getExactAnnotatedElement(Z.class, (String)"complex");
        Assert.assertNotNull((Object)complex);
        Assert.assertEquals(Method.class, complex.getClass());
    }

    @Test
    public void testGetExactAnnoatedElement() {
        AnnotatedElement complex = ReflectUtil.getExactAnnotatedElement(Arrays.asList(Object.class, Z.class), (String)"complex");
        Assert.assertNotNull((Object)complex);
        Assert.assertEquals(Method.class, complex.getClass());
    }

    @Test
    public void testGetAnnotatedElement() {
        AnnotatedElement complex = ReflectUtil.getAnnotatedElement(Z.class, (String)"complex");
        Assert.assertNotNull((Object)complex);
        Assert.assertEquals(Method.class, complex.getClass());
    }

    @Test
    public void testInvoke() {
        Z z = new Z();
        Assert.assertEquals((long)0L, (long)z.invocations);
        ReflectUtil.invoke((Object)z, (String)"invoke", (Object[])new Object[0]);
        Assert.assertEquals((long)1L, (long)z.invocations);
    }

    @Test
    public void testFieldName() {
        Assert.assertEquals((Object)"string", (Object)ReflectUtil.fieldName((String)"getString"));
    }

    class X {
        private final String fieldValue = "test X";

        X() {
        }

        private String getMethodValue() {
            return "test X2";
        }
    }

    class Y
    extends X {
        private final String fieldValue2 = "test Y";
        private final String fieldValue = "error";

        Y() {
        }

        private String getMethodValue2() {
            return "test Y2";
        }

        private String getMethodValue() {
            return "error 2";
        }
    }

    class Z
    extends X {
        public int invocations = 0;

        Z() {
        }

        public void invoke() {
            ++this.invocations;
        }

        private Z getComplex() {
            return new Z();
        }
    }
}

