/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.util.desktop;

import java.util.Collections;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;
import pl.matsuo.core.util.desktop.DesktopUIData;
import pl.matsuo.core.util.desktop.IRequest;

public abstract class DesktopUI<M>
extends Application {
    private static final Logger log = LoggerFactory.getLogger(DesktopUI.class);
    private final WebView webView = new WebView();
    final DesktopUIData<M> data;
    Stage stage;

    public DesktopUI(DesktopUIData<M> data) {
        this.data = data;
    }

    public void start(Stage stage) {
        this.stage = stage;
        stage.setTitle("Home");
        WebEngine webEngine = this.webView.getEngine();
        webEngine.setJavaScriptEnabled(false);
        webEngine.getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                log.info("Page loaded");
                this.setupAfterPageLoad();
            } else {
                log.info("State changed " + newState);
            }
        });
        webEngine.loadContent(this.pageContent("/"));
        BorderPane page = new BorderPane((Node)this.webView);
        Scene scene = new Scene((Parent)page);
        stage.setScene(scene);
        stage.show();
    }

    private void setupAfterPageLoad() {
        Document doc = this.webView.getEngine().getDocument();
        NodeList links = doc.getElementsByTagName("a");
        for (int i = 0; i < links.getLength(); ++i) {
            log.info("Found link. Adding listen function.");
            Element el = (Element)links.item(i);
            ((EventTarget)((Object)el)).addEventListener("click", this::handleEvent, false);
        }
        NodeList titles = doc.getElementsByTagName("title");
        if (titles.getLength() > 0) {
            this.stage.setTitle(titles.item(0).getTextContent().trim());
        }
    }

    void handleEvent(Event ev) {
        EventTarget target = ev.getTarget();
        org.w3c.dom.Node node = (org.w3c.dom.Node)((Object)target);
        String href = node.getAttributes().getNamedItem("href").getTextContent();
        if (!href.contains("#")) {
            Platform.runLater(() -> this.webView.getEngine().loadContent(this.pageContent(href)));
        } else {
            String nextView = this.data.getControllers().get(href).execute(null);
            if (nextView != null) {
                Platform.runLater(() -> this.webView.getEngine().loadContent(this.pageContent(nextView)));
            }
        }
    }

    private String pageContent(String path) {
        if (this.data.views.containsKey(path)) {
            log.info("Rendering page " + path);
            return this.data.views.get(path).view(IRequest.request(path, Collections.emptyMap()), this.data.model).renderFormatted();
        }
        if (this.data.views.containsKey("/404")) {
            return this.data.views.get("/404").view(IRequest.request(path, Collections.emptyMap()), this.data.model).renderFormatted();
        }
        return "Not found " + path;
    }

    public DesktopUIData<M> getData() {
        return this.data;
    }
}

