package pl.matsuo.core.util.desktop.component;

import static j2html.TagCreator.rawHtml;
import static java.lang.String.join;
import static java.nio.charset.StandardCharsets.UTF_8;

import j2html.tags.UnescapedText;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public enum BootstrapIcons {
  alarm_fill,
  alarm,
  align_bottom,
  align_center,
  align_end,
  align_middle,
  align_start,
  align_top,
  alt,
  app_indicator,
  app,
  archive_fill,
  archive,
  arrow_90deg_down,
  arrow_90deg_left,
  arrow_90deg_right,
  arrow_90deg_up,
  arrow_bar_down,
  arrow_bar_left,
  arrow_bar_right,
  arrow_bar_up,
  arrow_clockwise,
  arrow_counterclockwise,
  arrow_down_circle_fill,
  arrow_down_circle,
  arrow_down_left_circle_fill,
  arrow_down_left_circle,
  arrow_down_left_square_fill,
  arrow_down_left_square,
  arrow_down_left,
  arrow_down_right_circle_fill,
  arrow_down_right_circle,
  arrow_down_right_square_fill,
  arrow_down_right_square,
  arrow_down_right,
  arrow_down_short,
  arrow_down_square_fill,
  arrow_down_square,
  arrow_down,
  arrow_down_up,
  arrow_left_circle_fill,
  arrow_left_circle,
  arrow_left_right,
  arrow_left_short,
  arrow_left_square_fill,
  arrow_left_square,
  arrow_left,
  arrow_repeat,
  arrow_return_left,
  arrow_return_right,
  arrow_right_circle_fill,
  arrow_right_circle,
  arrow_right_short,
  arrow_right_square_fill,
  arrow_right_square,
  arrow_right,
  arrows_angle_contract,
  arrows_angle_expand,
  arrows_collapse,
  arrows_expand,
  arrows_fullscreen,
  arrows_move,
  arrow_up_circle_fill,
  arrow_up_circle,
  arrow_up_left_circle_fill,
  arrow_up_left_circle,
  arrow_up_left_square_fill,
  arrow_up_left_square,
  arrow_up_left,
  arrow_up_right_circle_fill,
  arrow_up_right_circle,
  arrow_up_right_square_fill,
  arrow_up_right_square,
  arrow_up_right,
  arrow_up_short,
  arrow_up_square_fill,
  arrow_up_square,
  arrow_up,
  aspect_ratio_fill,
  aspect_ratio,
  asterisk,
  at,
  award_fill,
  award,
  backspace_fill,
  backspace_reverse_fill,
  backspace_reverse,
  backspace,
  back,
  badge_4k_fill,
  badge_4k,
  badge_8k_fill,
  badge_8k,
  badge_ad_fill,
  badge_ad,
  badge_cc_fill,
  badge_cc,
  badge_hd_fill,
  badge_hd,
  badge_tm_fill,
  badge_tm,
  badge_vo_fill,
  badge_vo,
  bag_check_fill,
  bag_check,
  bag_dash_fill,
  bag_dash,
  bag_fill,
  bag_plus_fill,
  bag_plus,
  bag,
  bag_x_fill,
  bag_x,
  bar_chart_fill,
  bar_chart_line_fill,
  bar_chart_line,
  bar_chart_steps,
  bar_chart,
  basket2_fill,
  basket2,
  basket3_fill,
  basket3,
  basket_fill,
  basket,
  battery_charging,
  battery_full,
  battery_half,
  battery,
  bell_fill,
  bell,
  bezier2,
  bezier,
  bicycle,
  binoculars_fill,
  binoculars,
  blockquote_left,
  blockquote_right,
  book_fill,
  book_half,
  bookmark_check_fill,
  bookmark_check,
  bookmark_dash_fill,
  bookmark_dash,
  bookmark_fill,
  bookmark_heart_fill,
  bookmark_heart,
  bookmark_plus_fill,
  bookmark_plus,
  bookmarks_fill,
  bookmarks,
  bookmark_star_fill,
  bookmark_star,
  bookmark,
  bookmark_x_fill,
  bookmark_x,
  bookshelf,
  book,
  bootstrap_fill,
  bootstrap_icons,
  bootstrap_reboot,
  bootstrap,
  border_style,
  border_width,
  bounding_box_circles,
  bounding_box,
  box_arrow_down_left,
  box_arrow_down_right,
  box_arrow_down,
  box_arrow_in_down_left,
  box_arrow_in_down_right,
  box_arrow_in_down,
  box_arrow_in_left,
  box_arrow_in_right,
  box_arrow_in_up_left,
  box_arrow_in_up_right,
  box_arrow_in_up,
  box_arrow_left,
  box_arrow_right,
  box_arrow_up_left,
  box_arrow_up_right,
  box_arrow_up,
  box_seam,
  box,
  braces,
  bricks,
  briefcase_fill,
  briefcase,
  brightness_alt_high_fill,
  brightness_alt_high,
  brightness_alt_low_fill,
  brightness_alt_low,
  brightness_high_fill,
  brightness_high,
  brightness_low_fill,
  brightness_low,
  broadcast_pin,
  broadcast,
  brush_fill,
  brush,
  bucket_fill,
  bucket,
  bug_fill,
  bug,
  building,
  bullseye,
  calculator_fill,
  calculator,
  calendar2_check_fill,
  calendar2_check,
  calendar2_date_fill,
  calendar2_date,
  calendar2_day_fill,
  calendar2_day,
  calendar2_event_fill,
  calendar2_event,
  calendar2_fill,
  calendar2_minus_fill,
  calendar2_minus,
  calendar2_month_fill,
  calendar2_month,
  calendar2_plus_fill,
  calendar2_plus,
  calendar2_range_fill,
  calendar2_range,
  calendar2,
  calendar2_week_fill,
  calendar2_week,
  calendar2_x_fill,
  calendar2_x,
  calendar3_event_fill,
  calendar3_event,
  calendar3_fill,
  calendar3_range_fill,
  calendar3_range,
  calendar3,
  calendar3_week_fill,
  calendar3_week,
  calendar4_event,
  calendar4_range,
  calendar4,
  calendar4_week,
  calendar_check_fill,
  calendar_check,
  calendar_date_fill,
  calendar_date,
  calendar_day_fill,
  calendar_day,
  calendar_event_fill,
  calendar_event,
  calendar_fill,
  calendar_minus_fill,
  calendar_minus,
  calendar_month_fill,
  calendar_month,
  calendar_plus_fill,
  calendar_plus,
  calendar_range_fill,
  calendar_range,
  calendar,
  calendar_week_fill,
  calendar_week,
  calendar_x_fill,
  calendar_x,
  camera2,
  camera_fill,
  camera_reels_fill,
  camera_reels,
  camera,
  camera_video_fill,
  camera_video_off_fill,
  camera_video_off,
  camera_video,
  capslock_fill,
  capslock,
  card_checklist,
  card_heading,
  card_image,
  card_list,
  card_text,
  caret_down_fill,
  caret_down_square_fill,
  caret_down_square,
  caret_down,
  caret_left_fill,
  caret_left_square_fill,
  caret_left_square,
  caret_left,
  caret_right_fill,
  caret_right_square_fill,
  caret_right_square,
  caret_right,
  caret_up_fill,
  caret_up_square_fill,
  caret_up_square,
  caret_up,
  cart2,
  cart3,
  cart4,
  cart_check_fill,
  cart_check,
  cart_dash_fill,
  cart_dash,
  cart_fill,
  cart_plus_fill,
  cart_plus,
  cart,
  cart_x_fill,
  cart_x,
  cash_stack,
  cash,
  cast,
  chat_dots_fill,
  chat_dots,
  chat_fill,
  chat_left_dots_fill,
  chat_left_dots,
  chat_left_fill,
  chat_left_quote_fill,
  chat_left_quote,
  chat_left,
  chat_left_text_fill,
  chat_left_text,
  chat_quote_fill,
  chat_quote,
  chat_right_dots_fill,
  chat_right_dots,
  chat_right_fill,
  chat_right_quote_fill,
  chat_right_quote,
  chat_right,
  chat_right_text_fill,
  chat_right_text,
  chat_square_dots_fill,
  chat_square_dots,
  chat_square_fill,
  chat_square_quote_fill,
  chat_square_quote,
  chat_square,
  chat_square_text_fill,
  chat_square_text,
  chat,
  chat_text_fill,
  chat_text,
  check2_all,
  check2_circle,
  check2_square,
  check2,
  check_all,
  check_circle_fill,
  check_circle,
  check_square_fill,
  check_square,
  check,
  chevron_bar_contract,
  chevron_bar_down,
  chevron_bar_expand,
  chevron_bar_left,
  chevron_bar_right,
  chevron_bar_up,
  chevron_compact_down,
  chevron_compact_left,
  chevron_compact_right,
  chevron_compact_up,
  chevron_contract,
  chevron_double_down,
  chevron_double_left,
  chevron_double_right,
  chevron_double_up,
  chevron_down,
  chevron_expand,
  chevron_left,
  chevron_right,
  chevron_up,
  circle_fill,
  circle_half,
  circle_square,
  circle,
  clipboard_check,
  clipboard_data,
  clipboard_minus,
  clipboard_plus,
  clipboard,
  clipboard_x,
  clock_fill,
  clock_history,
  clock,
  cloud_arrow_down_fill,
  cloud_arrow_down,
  cloud_arrow_up_fill,
  cloud_arrow_up,
  cloud_check_fill,
  cloud_check,
  cloud_download_fill,
  cloud_download,
  cloud_fill,
  cloud_minus_fill,
  cloud_minus,
  cloud_plus_fill,
  cloud_plus,
  cloud_slash_fill,
  cloud_slash,
  cloud,
  cloud_upload_fill,
  cloud_upload,
  code_slash,
  code_square,
  code,
  collection_fill,
  collection_play_fill,
  collection_play,
  collection,
  columns_gap,
  columns,
  command,
  compass_fill,
  compass,
  cone_striped,
  cone,
  controller,
  cpu_fill,
  cpu,
  credit_card_2_back_fill,
  credit_card_2_back,
  credit_card_2_front_fill,
  credit_card_2_front,
  credit_card_fill,
  credit_card,
  crop,
  cup_fill,
  cup_straw,
  cup,
  cursor_fill,
  cursor,
  cursor_text,
  dash_circle_fill,
  dash_circle,
  dash_square_fill,
  dash_square,
  dash,
  diagram_2_fill,
  diagram_2,
  diagram_3_fill,
  diagram_3,
  diamond_fill,
  diamond_half,
  diamond,
  dice_1_fill,
  dice_1,
  dice_2_fill,
  dice_2,
  dice_3_fill,
  dice_3,
  dice_4_fill,
  dice_4,
  dice_5_fill,
  dice_5,
  dice_6_fill,
  dice_6,
  display_fill,
  display,
  distribute_horizontal,
  distribute_vertical,
  door_closed_fill,
  door_closed,
  door_open_fill,
  door_open,
  dot,
  download,
  droplet_fill,
  droplet_half,
  droplet,
  earbuds,
  easel_fill,
  easel,
  egg_fill,
  egg_fried,
  egg,
  eject_fill,
  eject,
  emoji_angry_fill,
  emoji_angry,
  emoji_dizzy_fill,
  emoji_dizzy,
  emoji_expressionless_fill,
  emoji_expressionless,
  emoji_frown_fill,
  emoji_frown,
  emoji_heart_eyes_fill,
  emoji_heart_eyes,
  emoji_laughing_fill,
  emoji_laughing,
  emoji_neutral_fill,
  emoji_neutral,
  emoji_smile_fill,
  emoji_smile,
  emoji_smile_upside_down_fill,
  emoji_smile_upside_down,
  emoji_sunglasses_fill,
  emoji_sunglasses,
  emoji_wink_fill,
  emoji_wink,
  envelope_fill,
  envelope_open_fill,
  envelope_open,
  envelope,
  exclamation_circle_fill,
  exclamation_circle,
  exclamation_diamond_fill,
  exclamation_diamond,
  exclamation_octagon_fill,
  exclamation_octagon,
  exclamation_square_fill,
  exclamation_square,
  exclamation,
  exclamation_triangle_fill,
  exclamation_triangle,
  exclude,
  eye_fill,
  eyeglasses,
  eye_slash_fill,
  eye_slash,
  eye,
  file_arrow_down_fill,
  file_arrow_down,
  file_arrow_up_fill,
  file_arrow_up,
  file_bar_graph_fill,
  file_bar_graph,
  file_binary_fill,
  file_binary,
  file_break_fill,
  file_break,
  file_check_fill,
  file_check,
  file_code_fill,
  file_code,
  file_diff_fill,
  file_diff,
  file_earmark_arrow_down_fill,
  file_earmark_arrow_down,
  file_earmark_arrow_up_fill,
  file_earmark_arrow_up,
  file_earmark_bar_graph_fill,
  file_earmark_bar_graph,
  file_earmark_binary_fill,
  file_earmark_binary,
  file_earmark_break_fill,
  file_earmark_break,
  file_earmark_check_fill,
  file_earmark_check,
  file_earmark_code_fill,
  file_earmark_code,
  file_earmark_diff_fill,
  file_earmark_diff,
  file_earmark_easel_fill,
  file_earmark_easel,
  file_earmark_excel_fill,
  file_earmark_excel,
  file_earmark_fill,
  file_earmark_font_fill,
  file_earmark_font,
  file_earmark_image_fill,
  file_earmark_image,
  file_earmark_lock2_fill,
  file_earmark_lock2,
  file_earmark_lock_fill,
  file_earmark_lock,
  file_earmark_medical_fill,
  file_earmark_medical,
  file_earmark_minus_fill,
  file_earmark_minus,
  file_earmark_music_fill,
  file_earmark_music,
  file_earmark_person_fill,
  file_earmark_person,
  file_earmark_play_fill,
  file_earmark_play,
  file_earmark_plus_fill,
  file_earmark_plus,
  file_earmark_post_fill,
  file_earmark_post,
  file_earmark_ppt_fill,
  file_earmark_ppt,
  file_earmark_richtext_fill,
  file_earmark_richtext,
  file_earmark_ruled_fill,
  file_earmark_ruled,
  file_earmark_slides_fill,
  file_earmark_slides,
  file_earmark_spreadsheet_fill,
  file_earmark_spreadsheet,
  file_earmark,
  file_earmark_text_fill,
  file_earmark_text,
  file_earmark_word_fill,
  file_earmark_word,
  file_earmark_x_fill,
  file_earmark_x,
  file_earmark_zip_fill,
  file_earmark_zip,
  file_easel_fill,
  file_easel,
  file_excel_fill,
  file_excel,
  file_fill,
  file_font_fill,
  file_font,
  file_image_fill,
  file_image,
  file_lock2_fill,
  file_lock2,
  file_lock_fill,
  file_lock,
  file_medical_fill,
  file_medical,
  file_minus_fill,
  file_minus,
  file_music_fill,
  file_music,
  file_person_fill,
  file_person,
  file_play_fill,
  file_play,
  file_plus_fill,
  file_plus,
  file_post_fill,
  file_post,
  file_ppt_fill,
  file_ppt,
  file_richtext_fill,
  file_richtext,
  file_ruled_fill,
  file_ruled,
  files_alt,
  file_slides_fill,
  file_slides,
  file_spreadsheet_fill,
  file_spreadsheet,
  files,
  file,
  file_text_fill,
  file_text,
  file_word_fill,
  file_word,
  file_x_fill,
  file_x,
  file_zip_fill,
  file_zip,
  film,
  filter_circle_fill,
  filter_circle,
  filter_left,
  filter_right,
  filter_square_fill,
  filter_square,
  filter,
  flag_fill,
  flag,
  flower1,
  flower2,
  flower3,
  folder2_open,
  folder2,
  folder_check,
  folder_fill,
  folder_minus,
  folder_plus,
  folder,
  folder_symlink_fill,
  folder_symlink,
  folder_x,
  fonts,
  forward_fill,
  forward,
  front,
  fullscreen_exit,
  fullscreen,
  funnel_fill,
  funnel,
  gear_fill,
  gear,
  gear_wide_connected,
  gear_wide,
  gem,
  geo_alt_fill,
  geo_alt,
  geo_fill,
  geo,
  gift_fill,
  gift,
  globe2,
  globe,
  graph_down,
  graph_up,
  grid_1x2_fill,
  grid_1x2,
  grid_3x2_gap_fill,
  grid_3x2_gap,
  grid_3x2,
  grid_3x3_gap_fill,
  grid_3x3_gap,
  grid_3x3,
  grid_fill,
  grid,
  grip_horizontal,
  grip_vertical,
  hammer,
  handbag_fill,
  handbag,
  hand_index,
  hand_index_thumb,
  hand_thumbs_down,
  hand_thumbs_up,
  hash,
  hdd_fill,
  hdd_network_fill,
  hdd_network,
  hdd_rack_fill,
  hdd_rack,
  hdd_stack_fill,
  hdd_stack,
  hdd,
  headphones,
  headset,
  heart_fill,
  heart_half,
  heart,
  heptagon_fill,
  heptagon_half,
  heptagon,
  hexagon_fill,
  hexagon_half,
  hexagon,
  hourglass_bottom,
  hourglass_split,
  hourglass,
  hourglass_top,
  house_door_fill,
  house_door,
  house_fill,
  house,
  hr,
  image_alt,
  image_fill,
  images,
  image,
  inboxes_fill,
  inboxes,
  inbox_fill,
  inbox,
  info_circle_fill,
  info_circle,
  info_square_fill,
  info_square,
  info,
  input_cursor,
  input_cursor_text,
  intersect,
  journal_album,
  journal_arrow_down,
  journal_arrow_up,
  journal_bookmark_fill,
  journal_bookmark,
  journal_check,
  journal_code,
  journal_medical,
  journal_minus,
  journal_plus,
  journal_richtext,
  journals,
  journal,
  journal_text,
  journal_x,
  joystick,
  justify_left,
  justify_right,
  justify,
  kanban_fill,
  kanban,
  keyboard_fill,
  keyboard,
  key_fill,
  key,
  ladder,
  lamp_fill,
  lamp,
  laptop_fill,
  laptop,
  layers_fill,
  layers_half,
  layers,
  layout_sidebar_inset_reverse,
  layout_sidebar_inset,
  layout_sidebar_reverse,
  layout_sidebar,
  layout_split,
  layout_text_sidebar_reverse,
  layout_text_sidebar,
  layout_text_window_reverse,
  layout_text_window,
  layout_three_columns,
  layout_wtf,
  life_preserver,
  lightning_fill,
  lightning,
  link_45deg,
  link,
  list_check,
  list_nested,
  list_ol,
  list_stars,
  list,
  list_task,
  list_ul,
  lock_fill,
  lock,
  mailbox2,
  mailbox,
  map_fill,
  map,
  markdown_fill,
  markdown,
  menu_app_fill,
  menu_app,
  menu_button_fill,
  menu_button,
  menu_button_wide_fill,
  menu_button_wide,
  menu_down,
  menu_up,
  mic_fill,
  mic_mute_fill,
  mic_mute,
  mic,
  minecart_loaded,
  minecart,
  moon,
  mouse2,
  mouse3,
  mouse,
  music_note_beamed,
  music_note_list,
  music_note,
  music_player_fill,
  music_player,
  newspaper,
  node_minus_fill,
  node_minus,
  node_plus_fill,
  node_plus,
  nut_fill,
  nut,
  octagon_fill,
  octagon_half,
  octagon,
  option,
  outlet,
  paperclip,
  paragraph,
  patch_check_fll,
  patch_check,
  patch_exclamation_fll,
  patch_exclamation,
  patch_minus_fll,
  patch_minus,
  patch_plus_fll,
  patch_plus,
  patch_question_fll,
  patch_question,
  pause_fill,
  pause,
  peace_fill,
  peace,
  pencil_fill,
  pencil_square,
  pencil,
  pen_fill,
  pen,
  pentagon_fill,
  pentagon_half,
  pentagon,
  people_fill,
  people,
  percent,
  person_badge_fill,
  person_badge,
  person_bounding_box,
  person_check_fill,
  person_check,
  person_circle,
  person_dash_fill,
  person_dash,
  person_fill,
  person_lines_fill,
  person_plus_fill,
  person_plus,
  person_square,
  person,
  person_x_fill,
  person_x,
  phone_fill,
  phone_landscape_fill,
  phone_landscape,
  phone,
  phone_vibrate,
  pie_chart_fill,
  pie_chart,
  pip_fill,
  pip,
  play_fill,
  play,
  plug_fill,
  plug,
  plus_circle_fill,
  plus_circle,
  plus_square_fill,
  plus_square,
  plus,
  power,
  printer_fill,
  printer,
  puzzle_fill,
  puzzle,
  question_circle_fill,
  question_circle,
  question_diamond_fill,
  question_diamond,
  question_octagon_fill,
  question_octagon,
  question_square_fill,
  question_square,
  question,
  receipt_cutoff,
  receipt,
  reception_0,
  reception_1,
  reception_2,
  reception_3,
  reception_4,
  reply_all_fill,
  reply_all,
  reply_fill,
  reply,
  rss_fill,
  rss,
  scissors,
  screwdriver,
  search,
  segmented_nav,
  server,
  share_fill,
  share,
  shield_check,
  shield_exclamation,
  shield_fill_check,
  shield_fill_exclamation,
  shield_fill_minus,
  shield_fill_plus,
  shield_fill,
  shield_fill_x,
  shield_lock_fill,
  shield_lock,
  shield_minus,
  shield_plus,
  shield_shaded,
  shield_slash_fill,
  shield_slash,
  shield,
  shield_x,
  shift_fill,
  shift,
  shop,
  shop_window,
  shuffle,
  signpost_2_fill,
  signpost_2,
  signpost_fill,
  signpost_split_fill,
  signpost_split,
  signpost,
  sim_fill,
  sim,
  skip_backward_fill,
  skip_backward,
  skip_end_fill,
  skip_end,
  skip_forward_fill,
  skip_forward,
  skip_start_fill,
  skip_start,
  slash_circle_fill,
  slash_circle,
  slash_square_fill,
  slash_square,
  slash,
  sliders,
  smartwatch,
  sort_alpha_down_alt,
  sort_alpha_down,
  sort_alpha_up_alt,
  sort_alpha_up,
  sort_down_alt,
  sort_down,
  sort_numeric_down_alt,
  sort_numeric_down,
  sort_numeric_up_alt,
  sort_numeric_up,
  sort_up_alt,
  sort_up,
  soundwave,
  speaker_fill,
  speaker,
  spellcheck,
  square_fill,
  square_half,
  square,
  star_fill,
  star_half,
  star,
  stickies_fill,
  stickies,
  sticky_fill,
  sticky,
  stop_fill,
  stoplights_fill,
  stoplights,
  stop,
  stopwatch_fill,
  stopwatch,
  subtract,
  suit_club_fill,
  suit_club,
  suit_diamond_fill,
  suit_diamond,
  suit_heart_fill,
  suit_heart,
  suit_spade_fill,
  suit_spade,
  sunglasses,
  sun,
  table,
  tablet_fill,
  tablet_landscape_fill,
  tablet_landscape,
  tablet,
  tag_fill,
  tags_fill,
  tags,
  tag,
  telephone_fill,
  telephone_forward_fill,
  telephone_forward,
  telephone_inbound_fill,
  telephone_inbound,
  telephone_minus_fill,
  telephone_minus,
  telephone_outbound_fill,
  telephone_outbound,
  telephone_plus_fill,
  telephone_plus,
  telephone,
  telephone_x_fill,
  telephone_x,
  terminal_fill,
  terminal,
  textarea_resize,
  textarea,
  textarea_t,
  text_center,
  text_indent_left,
  text_indent_right,
  text_left,
  text_paragraph,
  text_right,
  thermometer_half,
  thermometer,
  three_dots,
  three_dots_vertical,
  toggle2_off,
  toggle2_on,
  toggle_off,
  toggle_on,
  toggles2,
  toggles,
  tools,
  trash2_fill,
  trash2,
  trash_fill,
  trash,
  tree_fill,
  tree,
  triangle_fill,
  triangle_half,
  triangle,
  trophy_fill,
  trophy,
  truck_flatbed,
  truck,
  tv_fill,
  tv,
  type_bold,
  type_h1,
  type_h2,
  type_h3,
  type_italic,
  type_strikethrough,
  type,
  type_underline,
  ui_checks_grid,
  ui_checks,
  ui_radios_grid,
  ui_radios,
  union,
  unlock_fill,
  unlock,
  upc_scan,
  upc,
  upload,
  vector_pen,
  view_list,
  view_stacked,
  voicemail,
  volume_down_fill,
  volume_down,
  volume_mute_fill,
  volume_mute,
  volume_off_fill,
  volume_off,
  volume_up_fill,
  volume_up,
  vr,
  wallet2,
  wallet_fill,
  wallet,
  watch,
  wifi_1,
  wifi_2,
  wifi_off,
  wifi,
  window,
  wrench,
  x_circle_fill,
  x_circle,
  x_diamond_fill,
  x_diamond,
  x_octagon_fill,
  x_octagon,
  x_square_fill,
  x_square,
  x,
  zoom_in,
  zoom_out;

  private final Map<BootstrapIcons, String> loadedContent = new HashMap<>();

  // <svg class="bi bi-chevron-right" width="32" height="32" viewBox="0 0 20 20" fill="currentColor"
  //  xmlns="http://www.w3.org/2000/svg">
  //    <path fill-rule="evenodd"
  //  d="M6.646 3.646a.5.5 0 01.708 0l6 6a.5.5 0 010 .708l-6 6a.5.5 0 01-.708-.708L12.293 10 6.646
  // 4.354a.5.5 0 010-.708z"/>
  // </svg>
  public UnescapedText svg(String... additionalClasses) {
    return rawHtml(text(additionalClasses));
  }

  public String text(String... additionalClasses) {
    if (!loadedContent.containsKey(this)) {
      try {
        String resourcePath = "/bootstrap_icons/" + this.name().replaceAll("_", "-") + ".svg";
        String content = IOUtils.toString(getClass().getResource(resourcePath), UTF_8);
        loadedContent.put(this, content);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    String rawContent = loadedContent.get(this);
    // only if there are additional classes do regexp replacement
    if (additionalClasses.length > 0) {
      rawContent =
          rawContent.replaceAll(
              "\"bi ([^\"]+)\"", "\"bi $1 " + join(" ", additionalClasses) + "\"");
    }
    return rawContent;
  }

  public static void loadAll() {
    for (BootstrapIcons value : BootstrapIcons.values()) {
      value.svg();
    }
  }
}
