/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.util.function;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.matsuo.core.util.function.ThrowingExceptionsRunnable;
import pl.matsuo.core.util.function.ThrowingExceptionsSupplier;

public class FunctionalUtil {
    private static final Logger log = LoggerFactory.getLogger(FunctionalUtil.class);
    public static final Consumer<Exception> ignoringExConsumer = e -> log.warn("Ignoring exception", (Throwable)e);
    public static final Consumer<Exception> runtimeExConsumer = e -> {
        throw new RuntimeException((Throwable)e);
    };

    public static <E> AccessProvider<E> access(Supplier<E> getter, Consumer<E> setter) {
        return new AccessProvider<E>(getter, setter);
    }

    public static <E> AccessProvider<E> access(Object object, Field field) {
        return FunctionalUtil.access(() -> FunctionalUtil.ignoreEx(() -> field.get(object)), (E value) -> FunctionalUtil.ignoreEx(() -> {
            field.set(object, value);
            return null;
        }));
    }

    public static <E> E with(E object, Consumer<E> invoke) {
        invoke.accept(object);
        return object;
    }

    public static <E, F> F transform(E object, Function<E, F> invoke) {
        return invoke.apply(object);
    }

    public static <E, F> void with(E object, F object2, BiConsumer<E, F> invoke) {
        invoke.accept(object, object2);
    }

    public static <E> E ignoreEx(ThrowingExceptionsSupplier<E> throwsExceptions) {
        return (E)FunctionalUtil.processEx(throwsExceptions, (Exception e) -> {
            log.warn("Ignoring exception", (Throwable)e);
            return null;
        });
    }

    public static void ignoreEx(ThrowingExceptionsRunnable throwsExceptions) {
        FunctionalUtil.processEx(throwsExceptions, ignoringExConsumer);
    }

    public static <E> E runtimeEx(ThrowingExceptionsSupplier<E> throwsExceptions) {
        return (E)FunctionalUtil.processEx(throwsExceptions, (Exception e) -> {
            throw new RuntimeException((Throwable)e);
        });
    }

    public static void runtimeEx(ThrowingExceptionsRunnable throwsExceptions) {
        FunctionalUtil.runtimeEx(throwsExceptions, runtimeExConsumer);
    }

    public static void runtimeEx(ThrowingExceptionsRunnable throwsExceptions, Consumer<Exception> processEx) {
        FunctionalUtil.processEx(throwsExceptions, (Exception e) -> processEx.accept((Exception)e));
    }

    public static <E> E processEx(ThrowingExceptionsSupplier<E> throwsExceptions, Function<Exception, E> processEx) {
        try {
            return throwsExceptions.get();
        }
        catch (Exception e) {
            return processEx.apply(e);
        }
    }

    public static void processEx(ThrowingExceptionsRunnable throwsExceptions, Consumer<Exception> processEx) {
        try {
            throwsExceptions.run();
        }
        catch (Exception e) {
            processEx.accept(e);
        }
    }

    public static <E> Consumer<E> compose(Consumer<? super E> ... parts) {
        return value -> {
            for (Consumer part : parts) {
                part.accept(value);
            }
        };
    }

    public static <E> E either(boolean what, Supplier<E> ifTrue, Supplier<E> ifFalse) {
        return (what ? ifTrue : ifFalse).get();
    }

    public static void repeat(Supplier<Boolean> condition, Runnable exec) {
        while (condition.get().booleanValue()) {
            exec.run();
        }
    }

    public static <E> List<E> collectList(Supplier<Boolean> condition, Supplier<E> getter) {
        ArrayList result = new ArrayList();
        FunctionalUtil.repeat(condition, () -> result.add(getter.get()));
        return result;
    }

    public static class AccessProvider<E>
    implements Supplier<E>,
    Consumer<E> {
        private final Supplier<E> getter;
        private final Consumer<E> setter;

        AccessProvider(Supplier<E> getter, Consumer<E> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public AccessProvider setIfNull(Supplier<? extends E> creator, Consumer<? super E> initializer) {
            if (this.getter.get() == null) {
                E object = creator.get();
                initializer.accept(object);
                this.setter.accept(object);
            }
            return this;
        }

        public AccessProvider setIfNull(Supplier<? extends E> creator) {
            return this.setIfNull(creator, object -> {});
        }

        public AccessProvider invoke(Consumer<E> callable) {
            callable.accept(this.getter.get());
            return this;
        }

        @Override
        public void accept(E e) {
            this.setter.accept(e);
        }

        @Override
        public E get() {
            return this.getter.get();
        }
    }
}

