/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.util.function;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import pl.matsuo.core.util.function.FunctionalUtil;

public class TestFunctionalUtil {
    @Test
    public void testAccess() throws NoSuchFieldException {
        FunctionalUtil.AccessProvider invocations = FunctionalUtil.access((Object)new Z(), (Field)Z.class.getField("invocations"));
        Assert.assertEquals((Object)0, (Object)invocations.get());
        invocations.accept((Object)7);
        Assert.assertEquals((Object)7, (Object)invocations.get());
    }

    @Test
    public void testAccess1() {
        Z z = new Z();
        FunctionalUtil.AccessProvider access = FunctionalUtil.access(z::getComplex, z::setComplex);
        Assert.assertNull((Object)access.get());
        access.accept((Object)z);
        Assert.assertEquals((Object)z, (Object)access.get());
    }

    @Test
    public void testWith() {
        AtomicBoolean invoked = new AtomicBoolean(false);
        FunctionalUtil.with((Object)"string", value -> {
            Assert.assertEquals((Object)"string", (Object)value);
            invoked.set(true);
        });
        Assert.assertTrue((boolean)invoked.get());
    }

    @Test
    public void testTransform() {
        Assert.assertEquals((Object)7, (Object)FunctionalUtil.transform((Object)"string", value -> value.equals("string") ? Integer.valueOf(7) : null));
    }

    @Test
    public void testWith1() {
        AtomicBoolean invoked = new AtomicBoolean(false);
        FunctionalUtil.with((Object)"string", (Object)"string2", (v1, v2) -> {
            Assert.assertEquals((Object)"string", (Object)v1);
            Assert.assertEquals((Object)"string2", (Object)v2);
            invoked.set(true);
        });
        Assert.assertTrue((boolean)invoked.get());
    }

    @Test
    public void testIgnoreEx() {
        FunctionalUtil.ignoreEx(() -> {
            throw new RuntimeException("Should be ignored");
        });
    }

    @Test
    public void testIgnoreEx1() {
        Assert.assertEquals((Object)"val", (Object)FunctionalUtil.ignoreEx(() -> "val"));
        Assert.assertEquals(null, (Object)FunctionalUtil.ignoreEx(() -> {
            throw new RuntimeException("Should be ignored");
        }));
    }

    @Test(expected=RuntimeException.class)
    public void testRuntimeEx() {
        FunctionalUtil.runtimeEx(() -> {
            throw new Exception("Should be wrapped into RuntimeException");
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRuntimeEx1() {
        FunctionalUtil.runtimeEx(() -> {
            throw new Exception("Should be wrapped into RuntimeException");
        }, ex -> {
            throw new IllegalArgumentException((Throwable)ex);
        });
    }

    @Test
    public void testRuntimeEx2() {
        Assert.assertEquals((Object)"val", (Object)FunctionalUtil.runtimeEx(() -> "val"));
    }

    @Test(expected=RuntimeException.class)
    public void testRuntimeEx3() {
        Assert.assertEquals((Object)"val", (Object)FunctionalUtil.runtimeEx(() -> {
            throw new Exception();
        }));
    }

    @Test
    public void testProcessEx() {
        AtomicBoolean invoked = new AtomicBoolean(false);
        FunctionalUtil.processEx(() -> {
            throw new Exception("Should be wrapped into RuntimeException");
        }, ex -> invoked.set(true));
        Assert.assertTrue((boolean)invoked.get());
    }

    @Test
    public void testProcessEx1() {
        AtomicBoolean invoked = new AtomicBoolean(false);
        Assert.assertEquals((Object)"y", (Object)FunctionalUtil.processEx(() -> {
            throw new Exception("Should be wrapped into RuntimeException");
        }, ex -> {
            invoked.set(true);
            return "y";
        }));
        Assert.assertTrue((boolean)invoked.get());
    }

    @Test
    public void testProcessEx2() {
        AtomicBoolean invoked = new AtomicBoolean(false);
        Assert.assertEquals((Object)"x", (Object)FunctionalUtil.processEx(() -> "x", ex -> {
            invoked.set(true);
            return "y";
        }));
        Assert.assertFalse((boolean)invoked.get());
    }

    @Test
    public void testCompose() {
        AtomicBoolean invoked1 = new AtomicBoolean(false);
        AtomicBoolean invoked2 = new AtomicBoolean(false);
        FunctionalUtil.compose((Consumer[])new Consumer[]{val -> invoked1.set(true), val -> invoked2.set(true)}).accept("val");
        Assert.assertTrue((boolean)invoked1.get());
        Assert.assertTrue((boolean)invoked2.get());
    }

    @Test
    public void testEither() {
        Assert.assertEquals((Object)1, (Object)FunctionalUtil.either((boolean)true, () -> 1, () -> 2));
        Assert.assertEquals((Object)2, (Object)FunctionalUtil.either((boolean)false, () -> 1, () -> 2));
    }

    @Test
    public void testRepeat() {
        AtomicInteger counter = new AtomicInteger(3);
        AtomicInteger value = new AtomicInteger(0);
        FunctionalUtil.repeat(() -> {
            counter.set(counter.get() - 1);
            return counter.get() >= 0;
        }, () -> value.set(value.get() + 1));
        Assert.assertEquals((long)-1L, (long)counter.get());
        Assert.assertEquals((long)3L, (long)value.get());
    }

    @Test
    public void testCollectList() {
        AtomicInteger counter = new AtomicInteger(3);
        List integers = FunctionalUtil.collectList(() -> {
            counter.set(counter.get() - 1);
            return counter.get() >= 0;
        }, () -> counter.get());
        Assert.assertEquals((long)-1L, (long)counter.get());
        Assert.assertEquals(Arrays.asList(2, 1, 0), (Object)integers);
    }

    class Z {
        public int invocations = 0;
        public Z complex;

        Z() {
        }

        public int getInvocations() {
            return this.invocations;
        }

        public Z getComplex() {
            return this.complex;
        }

        public void setInvocations(int invocations) {
            this.invocations = invocations;
        }

        public void setComplex(Z complex) {
            this.complex = complex;
        }
    }
}

