/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.report;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.mock.web.MockHttpServletResponse;
import pl.matsuo.core.model.report.IPrintsReportParams;
import pl.matsuo.core.service.db.Database;
import pl.matsuo.core.service.facade.FacadeBuilder;
import pl.matsuo.core.service.print.IPrintsRendererService;
import pl.matsuo.core.service.print.PrintsRendererService;
import pl.matsuo.core.service.report.AbstractReportService;
import pl.matsuo.core.service.report.DataModelBuilder;
import pl.matsuo.core.service.report.IReportService;
import pl.matsuo.core.test.data.TestSessionState;
import pl.matsuo.core.util.ReflectUtil;
import pl.matsuo.core.web.controller.report.ReportsController;

@RunWith(value=MockitoJUnitRunner.class)
public class TestReportsController {
    @InjectMocks
    protected ReportsController reportsController = new ReportsController();
    @Spy
    IPrintsRendererService printsRendererService = new PrintsRendererService(){

        public byte[] renderHtml(String templateName, Object dataModel) {
            return "Rendered Html OK".getBytes();
        }

        public byte[] generatePrint(String templateName, Object dataModel) {
            return "Rendered Print OK".getBytes();
        }
    };
    @Mock
    Database database;
    @Mock
    TestSessionState sessionState;
    @Spy
    FacadeBuilder facadeBuilder = new FacadeBuilder();

    @Before
    public void setUp() {
        TestReportService testReportService = new TestReportService();
        this.reportsController.setReportServices(new IReportService[]{testReportService});
        Mockito.when((Object)this.printsRendererService.renderHtml(Matchers.anyString(), Matchers.anyObject())).thenReturn((Object)"Rendered OK".getBytes());
    }

    @Test
    public void testSetReportServices() {
        Map reportServicesMap = (Map)ReflectUtil.getValue((Object)this.reportsController, (String)"reportServicesMap");
        Assert.assertEquals((long)1L, (long)reportServicesMap.size());
        Assert.assertNotNull(reportServicesMap.get("testReport"));
    }

    @Test
    public void testGenerateReportPdf() throws Exception {
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.reportsController.generateReportPdf("testReport", new HashMap(), (HttpServletResponse)response);
    }

    @Test
    public void testGenerateReportXls() throws Exception {
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.reportsController.generateReportXls("testReport", new HashMap(), (HttpServletResponse)response);
    }

    class TestReportService
    extends AbstractReportService<IPrintsReportParams> {
        public TestReportService() {
            this.database = TestReportsController.this.database;
            this.sessionState = TestReportsController.this.sessionState;
        }

        protected void injectModel(DataModelBuilder dataModel, IPrintsReportParams params) {
        }
    }
}

