/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.exception;

import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import pl.matsuo.core.validation.ValidationErrors;

@ControllerAdvice
public class ValidationExceptionHandler {
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<Object> handleValidationException(MethodArgumentNotValidException pe) {
        BindingResult bindingResult = pe.getBindingResult();
        ValidationErrors errors = new ValidationErrors();
        for (FieldError fieldError : bindingResult.getFieldErrors()) {
            errors.getFieldErrors().put(fieldError.getField(), fieldError.getCode());
        }
        for (ObjectError error : bindingResult.getGlobalErrors()) {
            errors.getGlobalErrors().add(error.getCode());
        }
        return new ResponseEntity((Object)errors, HttpStatus.BAD_REQUEST);
    }
}

