/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.login;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import pl.matsuo.core.model.user.User;
import pl.matsuo.core.service.db.Database;
import pl.matsuo.core.service.login.CreateAccountData;
import pl.matsuo.core.service.login.ILoginService;
import pl.matsuo.core.service.login.LoginData;
import pl.matsuo.core.service.permission.IPermissionService;
import pl.matsuo.core.service.session.SessionState;

@RestController
@RequestMapping(value={"/login"})
public class LoginController {
    private static final Logger logger = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    SessionState sessionState;
    @Autowired
    Database database;
    @Autowired
    ILoginService loginService;
    @Autowired
    IPermissionService permissionService;

    @RequestMapping(method={RequestMethod.GET})
    public String loggedUsername() {
        if (this.sessionState.getUser() == null) {
            return null;
        }
        return this.sessionState.getUser().getUsername();
    }

    @RequestMapping(method={RequestMethod.POST})
    public String login(@RequestBody LoginData loginData) {
        return this.loginService.login(loginData);
    }

    @RequestMapping(value={"/activateAccount/{ticket}"})
    public void activateAccount(@PathVariable(value="ticket") String ticket, HttpServletResponse response) {
        this.loginService.activateAccount(ticket);
        try {
            response.sendRedirect("/");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/createAccount"}, method={RequestMethod.POST})
    public String createAccount(@RequestBody CreateAccountData createAccountData) {
        return "Account confirmation ticket: " + this.loginService.createAccount(createAccountData, true);
    }

    @RequestMapping(value={"/logoff"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void logoff() {
        this.permissionService.logoff();
    }

    @RequestMapping(value={"/remindPassword/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void remindPassword(@PathVariable(value="username") String username) {
        username.length();
    }

    @RequestMapping(value={"/user"}, method={RequestMethod.GET})
    public User loggedUser() {
        return this.sessionState.getUser();
    }

    @RequestMapping(value={"/permissions"}, method={RequestMethod.POST})
    public List<Boolean> permissions(@RequestBody List<String> permissions) {
        ArrayList<Boolean> permissionsCheck = new ArrayList<Boolean>();
        for (String permission : permissions) {
            permissionsCheck.add(this.permissionService.isPermitted(permission));
        }
        return permissionsCheck;
    }

    @RequestMapping(value={"/loginTime"}, method={RequestMethod.GET})
    public Long loginTime() {
        return this.sessionState.getLoginTime();
    }
}

