/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.log.AccessLog;
import pl.matsuo.core.service.permission.PermissionService;
import pl.matsuo.core.web.filter.AbstractFilter;

@Component(value="accessLogFilter")
public class AccessLogFilter
extends AbstractFilter {
    @Autowired
    PermissionService permissionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        AccessLog accessLog = new AccessLog();
        accessLog.setIp(httpRequest.getRemoteAddr());
        accessLog.setRequest(httpRequest.getRequestURI());
        accessLog.setMethod(httpRequest.getMethod());
        if (!httpRequest.getParameterMap().keySet().isEmpty()) {
            accessLog.setParameters(httpRequest.getParameterMap().toString());
        }
        if (this.sessionState.getUser() != null) {
            accessLog.setIdUser(this.sessionState.getUser().getId());
        }
        this.database.create((AbstractEntity)accessLog);
        try {
            chain.doFilter(request, response);
        }
        finally {
            accessLog.setStatus(Integer.valueOf(httpResponse.getStatus()));
            try {
                if (httpResponse.getStatus() >= 300 && httpResponse.getStatus() < 400) {
                    this.database.delete((AbstractEntity)accessLog);
                } else {
                    this.database.update((AbstractEntity)accessLog);
                }
            }
            catch (RuntimeException e) {}
        }
    }
}

