/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import pl.matsuo.core.model.api.Initializer;
import pl.matsuo.core.model.query.AbstractQuery;
import pl.matsuo.core.model.query.Query;
import pl.matsuo.core.model.query.condition.Condition;
import pl.matsuo.core.model.user.User;
import pl.matsuo.core.params.IQueryRequestParams;
import pl.matsuo.core.service.db.Database;
import pl.matsuo.core.web.controller.AbstractController;

public class TestAbstractController {
    Database database = (Database)Mockito.mock(Database.class);
    AbstractController controller = new AbstractController<User, IQueryRequestParams>(){

        protected List<Function<User, String>> queryMatchers() {
            return Arrays.asList(User::getUsername, User::getPassword);
        }

        protected List<? extends Initializer<? super User>> entityInitializers() {
            return Arrays.asList(user -> user.setUsername("tester"));
        }
    };

    @Before
    public void setup() {
        this.controller.database = this.database;
    }

    @Test
    public void testListQuery() throws Exception {
        IQueryRequestParams params = (IQueryRequestParams)Mockito.mock(IQueryRequestParams.class);
        Mockito.when((Object)params.getQuery()).thenReturn((Object)"some text");
        AbstractQuery query = this.controller.listQuery(params, new Condition[]{q -> "test string"});
        Assert.assertEquals((Object)"FROM pl.matsuo.core.model.user.User user WHERE test string AND (lower(username) like '%some%' OR lower(password) like '%some%') AND (lower(username) like '%text%' OR lower(password) like '%text%')", (Object)query.printQuery());
    }

    @Test
    public void testList() throws Exception {
        IQueryRequestParams params = (IQueryRequestParams)Mockito.mock(IQueryRequestParams.class);
        Mockito.when((Object)params.getQuery()).thenReturn((Object)"some text");
        Mockito.when((Object)this.database.find((Query)Mockito.any(Query.class))).then(invocation -> {
            AbstractQuery query = (AbstractQuery)invocation.getArguments()[0];
            Assert.assertEquals((Object)"FROM pl.matsuo.core.model.user.User user WHERE (lower(username) like '%some%' OR lower(password) like '%some%') AND (lower(username) like '%text%' OR lower(password) like '%text%')", (Object)query.printQuery());
            return Collections.nCopies(100, new User());
        });
        Assert.assertEquals((long)100L, (long)this.controller.list(params).size());
    }

    @Test
    public void testList_limitAndOffset() throws Exception {
        IQueryRequestParams params = (IQueryRequestParams)Mockito.mock(IQueryRequestParams.class);
        Mockito.when((Object)params.getQuery()).thenReturn((Object)"some text");
        Mockito.when((Object)params.getLimit()).thenReturn((Object)20);
        Mockito.when((Object)params.getOffset()).thenReturn((Object)10);
        Mockito.when((Object)this.database.find((Query)Mockito.any(Query.class))).then(invocation -> {
            SessionFactory sessionFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
            org.hibernate.Query hQuery = (org.hibernate.Query)Mockito.mock(org.hibernate.Query.class);
            Session session = (Session)Mockito.mock(Session.class);
            Mockito.when((Object)sessionFactory.getCurrentSession()).thenReturn((Object)session);
            Mockito.when((Object)session.createQuery(Mockito.anyString())).thenReturn((Object)hQuery);
            AbstractQuery query = (AbstractQuery)invocation.getArguments()[0];
            Field field = query.getClass().getDeclaredField("sessionFactory");
            try {
                field.setAccessible(true);
                field.set(query, sessionFactory);
            }
            finally {
                field.setAccessible(false);
            }
            query.query(null);
            ((org.hibernate.Query)Mockito.verify((Object)hQuery)).setMaxResults(20);
            ((org.hibernate.Query)Mockito.verify((Object)hQuery)).setFirstResult(10);
            return Collections.nCopies(5, new User());
        });
        Assert.assertEquals((long)5L, (long)this.controller.list(params).size());
    }

    @Test
    public void testList1() throws Exception {
        Mockito.when((Object)this.database.find((Query)Mockito.any(Query.class))).then(invocation -> {
            AbstractQuery query = (AbstractQuery)invocation.getArguments()[0];
            Assert.assertEquals((Object)"FROM pl.matsuo.core.model.user.User user WHERE test_x AND test_y", (Object)query.printQuery());
            return Collections.nCopies(33, new User());
        });
        Assert.assertEquals((long)33L, (long)this.controller.list(new Condition[]{q -> "test_x", q -> "test_y"}).size());
    }

    @Test
    public void testEntityQuery() throws Exception {
        Assert.assertEquals((Object)"FROM pl.matsuo.core.model.user.User user WHERE test_x AND test_y", (Object)this.controller.entityQuery(User.class, new Condition[]{q -> "test_x", q -> "test_y"}).printQuery());
    }

    @Test
    public void testListByIds() throws Exception {
        Mockito.when((Object)this.database.find((Query)Mockito.any(Query.class))).then(invocation -> {
            AbstractQuery query = (AbstractQuery)invocation.getArguments()[0];
            Assert.assertEquals((Object)"FROM pl.matsuo.core.model.user.User user WHERE id in (1, 2, 3)", (Object)query.printQuery());
            return Collections.nCopies(3, new User());
        });
        Assert.assertEquals((long)3L, (long)this.controller.listByIds(Arrays.asList(1, 2, 3)).size());
    }

    @Test
    public void testFind() throws Exception {
        User user = new User();
        Mockito.when((Object)this.database.findById((Class)Mockito.any(Class.class), (Integer)Mockito.any(Integer.class), (Initializer[])Mockito.any(Initializer[].class))).thenReturn((Object)user);
        Assert.assertTrue((this.controller.find(Integer.valueOf(7)).getBody() == user ? 1 : 0) != 0);
    }

    @Test
    public void testEntityInitializers() throws Exception {
        Mockito.when((Object)this.database.findById((Class)Mockito.any(Class.class), (Integer)Mockito.any(Integer.class), new Initializer[]{(Initializer)Mockito.any(Initializer.class)})).then(invocation -> {
            Assert.assertEquals((long)3L, (long)invocation.getArguments().length);
            Initializer initializer = (Initializer)invocation.getArguments()[2];
            User user = new User();
            initializer.init((Object)user);
            Assert.assertEquals((Object)"tester", (Object)user.getUsername());
            return user;
        });
        Assert.assertEquals((Object)"tester", (Object)((User)this.controller.find(Integer.valueOf(7)).getBody()).getUsername());
    }

    @Test
    public void testCreate() throws Exception {
    }

    @Test
    public void testUpdate() throws Exception {
    }

    @Test
    public void testDelete() throws Exception {
    }

    @Test
    public void testUpdate1() throws Exception {
    }

    @Test
    public void testChildLocation() throws Exception {
    }

    @Test
    public void testHttpEntity() throws Exception {
    }
}

