/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.organization;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import pl.matsuo.core.model.organization.OrganizationUnit;
import pl.matsuo.core.model.query.AbstractQuery;
import pl.matsuo.core.model.query.Query;
import pl.matsuo.core.params.IQueryRequestParams;
import pl.matsuo.core.service.db.Database;
import pl.matsuo.core.service.facade.FacadeBuilder;
import pl.matsuo.core.service.facade.IFacadeBuilder;
import pl.matsuo.core.web.controller.ControllerTestUtil;
import pl.matsuo.core.web.controller.organization.PayerController;

public class TestPayerController {
    @Autowired
    Database database = (Database)Mockito.mock(Database.class);
    @Autowired
    PayerController controller = new PayerController();
    FacadeBuilder facadeBuilder = (FacadeBuilder)Mockito.mock(FacadeBuilder.class);

    public TestPayerController() {
        this.controller.setDatabase(this.database);
        this.controller.setFacadeBuilder((IFacadeBuilder)this.facadeBuilder);
    }

    @Test
    public void testLoadingMediq() {
        Mockito.when((Object)this.database.find((Query)Mockito.any(Query.class))).then(invocation -> {
            String queryString = ((AbstractQuery)invocation.getArguments()[0]).printQuery();
            String expected1 = "FROM pl.matsuo.core.model.organization.Person person WHERE (lower(firstName) like '%mediq%' OR lower(lastName) like '%mediq%')";
            String expected2 = "FROM pl.matsuo.core.model.organization.OrganizationUnit organizationUnit WHERE (lower(fullName) like '%mediq%' OR lower(shortName) like '%mediq%' OR lower(code) like '%mediq%')";
            Assert.assertTrue((String)("Query does not match:\n" + queryString.trim()), (queryString.trim().equals(expected1) || queryString.trim().equals(expected2) ? 1 : 0) != 0);
            return Arrays.asList(new OrganizationUnit());
        });
        this.controller.list(ControllerTestUtil.queryFacade(IQueryRequestParams.class, "query", "mediq"));
    }
}

