/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.print;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.test.context.ContextConfiguration;
import pl.matsuo.core.AbstractDbTest;
import pl.matsuo.core.conf.GeneralConfig;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.print.IPrintFacade;
import pl.matsuo.core.model.print.KeyValuePrint;
import pl.matsuo.core.model.query.condition.QueryPart;
import pl.matsuo.core.model.report.IPrintsReportParams;
import pl.matsuo.core.service.facade.FacadeBuilder;
import pl.matsuo.core.service.print.AbstractPrintService;
import pl.matsuo.core.service.print.PrintsRendererService;
import pl.matsuo.core.web.controller.print.PrintController;

@ContextConfiguration(classes={PrintController.class, PrintsRendererService.class, GeneralConfig.class, TemplateNamePrintService.class})
public class TestPrintController
extends AbstractDbTest {
    @Autowired
    PrintController printController;
    @Autowired
    FacadeBuilder facadeBuilder;
    KeyValuePrint print;

    @Before
    public void setupDatabase() {
        this.print = new KeyValuePrint();
        this.print.setPrintClass(TemplateName.class);
        this.database.create((AbstractEntity)this.print);
    }

    @Test
    public void testGeneratePrint() throws Exception {
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.printController.generatePrint(this.print.getId(), (HttpServletResponse)response);
    }

    @Test
    public void testGeneratePrint1() throws Exception {
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.printController.generatePrint(this.print, (HttpServletResponse)response);
    }

    @Test
    public void testGeneratePrint2() throws Exception {
        MockHttpServletResponse response = new MockHttpServletResponse();
        HashMap dataModel = new HashMap();
        this.printController.generatePrint("templateName.ftl", "fileName", dataModel, (HttpServletResponse)response);
    }

    @Test
    public void testFindPrints() throws Exception {
        this.printController.findPrints((IPrintsReportParams)this.facadeBuilder.createFacade(new HashMap(), IPrintsReportParams.class), "keyValuePrint.idEntity", new QueryPart[0]);
    }

    @Test
    public void testList() throws Exception {
        this.printController.list((IPrintsReportParams)this.facadeBuilder.createFacade(new HashMap(), IPrintsReportParams.class));
    }

    @Test
    public void testListByIdEntities() throws Exception {
        this.printController.listByIdEntities(Arrays.asList(17));
    }

    @Service
    public static class TemplateNamePrintService
    extends AbstractPrintService<TemplateName> {
        protected void buildModel(TemplateName print, Map dataModel) {
        }

        public String getFileName(TemplateName print) {
            return "templateName";
        }
    }

    public static interface TemplateName
    extends IPrintFacade {
    }
}

