/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.user;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import pl.matsuo.core.exception.RestProcessingException;
import pl.matsuo.core.model.api.Initializer;
import pl.matsuo.core.model.organization.Person;
import pl.matsuo.core.model.user.User;
import pl.matsuo.core.model.user.initializer.UserInitializer;
import pl.matsuo.core.util.SecurityUtil;
import pl.matsuo.core.web.controller.AbstractControllerTest;
import pl.matsuo.core.web.controller.ControllerTestUtil;
import pl.matsuo.core.web.controller.user.IBlockUserParams;
import pl.matsuo.core.web.controller.user.IChangePasswordParams;
import pl.matsuo.core.web.controller.user.UserController;

@ContextConfiguration(classes={UserController.class})
public class TestUserController
extends AbstractControllerTest {
    @Autowired
    protected UserController userController;
    protected User user;

    @Before
    public void setup() {
        this.user = (User)this.database.findAll(User.class, new Initializer[]{new UserInitializer()}).get(0);
    }

    @Test
    public void testCreateUser() throws Exception {
        Person person = new Person();
        person.setFirstName("Ryszard");
        person.setLastName("Monty");
        User user = new User();
        user.setUsername("username");
        user.setPassword("password");
        user.setPerson(person);
        Integer idUser = ControllerTestUtil.idFromLocation(this.userController.create(user, new StringBuffer("")));
        user = (User)this.database.findById(User.class, idUser, new Initializer[0]);
        Assert.assertEquals((Object)"Ryszard", (Object)user.getPerson().getFirstName());
        Assert.assertEquals((Object)"Monty", (Object)user.getPerson().getLastName());
        Assert.assertEquals((Object)"username", (Object)user.getUsername());
        Assert.assertEquals((Object)SecurityUtil.passwordHash((String)"password"), (Object)user.getPassword());
    }

    @Test(expected=RestProcessingException.class)
    public void testUpdatePassword_PasswordTooShort() throws Exception {
        IChangePasswordParams params = (IChangePasswordParams)this.facadeBuilder.createFacade(new HashMap(), IChangePasswordParams.class);
        params.setId(this.user.getId());
        params.setNewPassword("aaa");
        params.setConfirmationPassword("bbb");
        this.userController.updatePassword(params);
    }

    @Test(expected=RestProcessingException.class)
    public void testUpdatePassword_ConfirmationMissmatch() throws Exception {
        IChangePasswordParams params = (IChangePasswordParams)this.facadeBuilder.createFacade(new HashMap(), IChangePasswordParams.class);
        params.setId(this.user.getId());
        params.setNewPassword("aaafdsfdafdafds");
        params.setConfirmationPassword("bbbfdsfdfafdfadf");
        this.userController.updatePassword(params);
    }

    @Test(expected=RestProcessingException.class)
    public void testUpdateOwnPassword_WrongPassword() throws Exception {
        this.sessionState.setUser(this.user);
        IChangePasswordParams params = (IChangePasswordParams)this.facadeBuilder.createFacade(new HashMap(), IChangePasswordParams.class);
        params.setActualPassword("test__");
        params.setNewPassword("kredka111");
        params.setConfirmationPassword("kredka111");
        this.userController.updateOwnPassword(params);
    }

    @Test
    @DirtiesContext
    public void testUpdatePassword() throws Exception {
        IChangePasswordParams params = (IChangePasswordParams)this.facadeBuilder.createFacade(new HashMap(), IChangePasswordParams.class);
        params.setId(this.user.getId());
        params.setActualPassword("6%86P#WnukNp2gBm");
        params.setNewPassword("kredka111");
        params.setConfirmationPassword("kredka111");
        this.userController.updatePassword(params);
    }

    @Test
    @DirtiesContext
    public void testUpdateOwnPassword() throws Exception {
        this.sessionState.setUser(this.user);
        IChangePasswordParams params = (IChangePasswordParams)this.facadeBuilder.createFacade(new HashMap(), IChangePasswordParams.class);
        params.setId(Integer.valueOf(0));
        params.setActualPassword("6%86P#WnukNp2gBm");
        params.setNewPassword("kredka111");
        params.setConfirmationPassword("kredka111");
        this.userController.updateOwnPassword(params);
        Assert.assertEquals((Object)SecurityUtil.passwordHash((String)"kredka111"), (Object)((User)this.database.findById(User.class, this.user.getId(), new Initializer[0])).getPassword());
    }

    @Test
    @DirtiesContext
    public void testBlockUser() throws Exception {
        IBlockUserParams params = (IBlockUserParams)this.facadeBuilder.createFacade(new HashMap(), IBlockUserParams.class);
        params.setId(this.user.getId());
        params.setBlock(Boolean.valueOf(true));
        this.userController.blockUser(params);
        Assert.assertTrue((boolean)((User)this.database.findById(User.class, this.user.getId(), new Initializer[0])).getBlocked());
        params.setBlock(Boolean.valueOf(false));
        this.userController.blockUser(params);
        Assert.assertFalse((boolean)((User)this.database.findById(User.class, this.user.getId(), new Initializer[0])).getBlocked());
    }
}

