/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.scope;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import pl.matsuo.core.service.session.SessionState;
import pl.matsuo.core.web.scope.ScopeConfig;
import pl.matsuo.core.web.scope.WideSessionScope;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={SessionState.class, ScopeConfig.class})
public class TestWideSessionScope {
    @Autowired
    SessionState sessionState;

    @Test
    public void testAutowiringOutsideWebRequest() throws Exception {
        this.sessionState.getIdBucket();
    }

    @Test
    public void testWideSessionScope() {
        WideSessionScope wideSessionScope = new WideSessionScope();
        Assert.assertEquals((Object)"non_web_", (Object)wideSessionScope.getConversationId());
        Assert.assertEquals((long)13L, (long)wideSessionScope.getScope());
        ThreadLocal<String> threadLocal = new ThreadLocal<String>();
        threadLocal.set("test object");
        wideSessionScope.objectHolders.put("object", threadLocal);
        Assert.assertEquals((Object)"test object", (Object)wideSessionScope.remove("object"));
    }
}

