/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.view;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import pl.matsuo.core.util.function.ThrowingExceptionsConsumer;
import pl.matsuo.core.web.view.BootstrapRenderer;
import pl.matsuo.core.web.view.ITestModel;
import pl.matsuo.core.web.view.TestModel;

public class TestBootstrapRenderer {
    protected BootstrapRenderer renderer = new BootstrapRenderer();

    public TestBootstrapRenderer() {
        this.renderer.init();
    }

    private void checkConstraints(String rendered, ThrowingExceptionsConsumer<String> ... validations) throws Exception {
        Assert.assertNotNull((Object)rendered);
        for (ThrowingExceptionsConsumer<String> validation : validations) {
            validation.accept((Object)rendered);
        }
    }

    private void checkConstraints(Class<?> model, String field, ThrowingExceptionsConsumer<String> ... validations) throws Exception {
        this.checkConstraints(this.renderer.create(model).render(new String[]{field}), validations);
    }

    protected void assertContains(String rendered, String subPart) {
        Assert.assertTrue((String)("fragment:\n" + subPart + "\nnot found in rendered:\n" + rendered), (boolean)rendered.contains(subPart));
    }

    protected ThrowingExceptionsConsumer<String> containsAssertions(String ... parts) {
        return rendered -> Arrays.asList(parts).forEach(part -> this.assertContains((String)rendered, (String)part));
    }

    @Test
    public void testRendering() throws Exception {
        this.checkConstraints(this.renderer.create(TestModel.class).render(new String[]{"date", "time", "enumValue"}), new ThrowingExceptionsConsumer[0]);
        this.checkConstraints(this.renderer.renderSingleField(TestModel.class, "testType", new String[0]), new ThrowingExceptionsConsumer[0]);
        this.checkConstraints(this.renderer.create(TestModel.class).renderWithName("enumValue", "htmlFieldName"), new ThrowingExceptionsConsumer[0]);
    }

    @Test
    public void testPasswordRendering() throws Exception {
        this.checkConstraints(TestModel.class, "password", this.containsAssertions("type=\"password\""));
    }

    @Test
    public void testBooleanRendering() throws Exception {
        this.checkConstraints(TestModel.class, "bool", this.containsAssertions("type=\"checkbox\"", "class=\" col-sm-6 checkbox\""));
    }

    @Test
    public void testRenderingBasedOnInterface() throws Exception {
        this.checkConstraints(this.renderer.create(ITestModel.class).render(new String[]{"date", "time", "enumValue"}), this.containsAssertions("<option "));
    }

    @Test
    public void testDateRendering() throws Exception {
        this.checkConstraints(TestModel.class, "date", this.containsAssertions("input", "type=\"text\"", "mt-datepicker=\"datepickerOptions\""));
    }

    @Test
    public void testStringRendering() throws Exception {
        this.checkConstraints(TestModel.class, "text", this.containsAssertions("input", "type=\"text\""));
    }

    @Test
    public void testIntegerRendering() throws Exception {
        this.checkConstraints(TestModel.class, "duration", rendered -> {
            this.containsAssertions("input", "type=\"text\"", "ng-pattern=\"/^([0-9]+([.,][0-9]+)?)?$/\"").accept(rendered);
            Assert.assertFalse((boolean)rendered.contains("ui-select"));
        });
    }

    @Test
    public void testIdRendering() throws Exception {
        this.checkConstraints(TestModel.class, "subModel.id", this.containsAssertions("ui-select"));
    }

    @Test
    public void testPatternOnAnnotationRendering() throws Exception {
        this.checkConstraints(TestModel.class, "duration", this.containsAssertions("input", "type=\"text\"", "ng-pattern=\"/^([0-9]+([.,][0-9]+)?)?$/\""));
    }

    @Test
    public void testGenereSelectForReferenceId() throws Exception {
        this.checkConstraints(TestModel.class, "reference", this.containsAssertions("ui-select", "ng-model=\"reference.value\"", "ng-disabled=\"reference.options.disabled\""));
    }

    @Test
    public void testGenereSelectForReference() throws Exception {
        this.checkConstraints(TestModel.class, "subModel", this.containsAssertions("ui-select", "ng-model=\"entity.subModel\"", "ng-disabled=\"subModel.options.disabled\""));
    }

    @Test
    public void testRenderingWithCustomName() throws Exception {
        this.checkConstraints(this.renderer.create(TestModel.class).entityName("customEntityName").render(new String[]{"date"}), this.containsAssertions("ng-model=\"customEntityName.date\""));
    }

    @Test
    public void testRenderingInlineElements() throws Exception {
        this.checkConstraints(this.renderer.create(TestModel.class).entityName("customEntityName").attribute("ng-test", "ng-value").render(new String[]{"date", "date"}), rendered -> {
            this.assertContains((String)rendered, "ng-model=\"customEntityName.date\"");
            Assert.assertTrue((rendered.split("ng-test=\"ng-value\"").length == 3 ? 1 : 0) != 0);
        });
    }

    @Test
    public void testRenderingAdditionalAttribute() throws Exception {
        this.checkConstraints(this.renderer.create(TestModel.class).attribute("test-attr", "test-value").attribute("id", "id-value").render(new String[]{"subModel.date"}), rendered -> {
            this.assertContains((String)rendered, "test-attr=\"test-value\"");
            this.assertContains((String)rendered, "id=\"id-value\"");
            Assert.assertFalse((boolean)rendered.contains("id=\"entity.subModel.date\""));
        });
    }
}

