/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller;

import java.net.URI;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriTemplate;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.params.IQueryRequestParams;
import pl.matsuo.core.web.controller.AbstractSearchController;

@Transactional
public abstract class AbstractController<E extends AbstractEntity, P extends IQueryRequestParams>
extends AbstractSearchController<E, P> {
    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public HttpEntity<E> create(@RequestBody @Valid E entity, @Value(value="#{request.requestURL}") StringBuffer parentUri) {
        entity = this.database.create(entity);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.childLocation(parentUri, entity.getId()));
        return new HttpEntity((MultiValueMap)headers);
    }

    @RequestMapping(method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void update(@RequestBody @Valid E entity) {
        this.database.update(entity);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable(value="id") Integer id) {
        this.database.delete(this.entityType, id);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void update(@PathVariable(value="id") Integer id, @RequestBody E entity) {
        entity.setId(id);
        this.database.create(entity);
    }

    protected URI childLocation(StringBuffer parentUri, Object childId) {
        UriTemplate uri = new UriTemplate(parentUri.append("/{childId}").toString());
        return uri.expand(new Object[]{childId});
    }

    protected <E> HttpEntity<E> httpEntity(AbstractEntity entity, StringBuffer parentUri) {
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.childLocation(parentUri, entity.getId()));
        return new HttpEntity((MultiValueMap)headers);
    }
}

