/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.view;

import com.google.common.base.Joiner;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import pl.matsuo.core.model.validation.EntityReference;
import pl.matsuo.core.model.validation.PasswordField;
import pl.matsuo.core.util.ReflectUtil;
import pl.matsuo.core.util.collection.ArrayUtil;
import pl.matsuo.core.web.view.HtmlElement;
import pl.matsuo.core.web.view.HtmlPart;
import pl.matsuo.core.web.view.HtmlText;

@Component
public class BootstrapRenderer {
    private static Logger logger = Logger.getLogger(BootstrapRenderer.class.getName());
    private static BootstrapRenderer bootstrapRenderer;
    Validator validator;

    @PostConstruct
    public void init() {
        if (bootstrapRenderer != null) {
            logger.severe("Second spring bean BootstrapRenderer");
        }
        bootstrapRenderer = this;
        this.validator = Validation.buildDefaultValidatorFactory().getValidator();
    }

    protected String renderField(Class<?> fieldType, AnnotatedElement annotatedElement, String fieldName, BootstrapRenderingBuilder builder) {
        String fullFieldName = this.fullFieldName(builder.entityName, fieldName);
        return this.createControlGroup(fullFieldName, this.createControls(fieldType, annotatedElement, fieldName, builder.entityType, fullFieldName, builder, (String[])ArrayUtils.addAll((Object[])builder.cssClasses, (Object[])new String[]{this.lastNameElement(fieldName.split("[.]"))})));
    }

    private String createControlGroup(String fullFieldName, HtmlElement controls) {
        return this.div(Arrays.asList("form-group", fullFieldName.replaceAll("[.-]", "_"), this.bindServerErrorPath(fullFieldName, " && 'error' || ''")), this.el("label", Arrays.asList("col-sm-4 control-label"), new HtmlPart[0]).attr("for", fullFieldName).attr("translate", fullFieldName), controls).toString();
    }

    private String serverErrorPath(String fullFieldName) {
        return this.formField(fullFieldName, "serverError");
    }

    private String bindServerErrorPath(String fullFieldName, String suffix) {
        return "{{" + this.formField(fullFieldName, "serverError") + suffix + "}}";
    }

    private String formField(String fullFieldName, String field) {
        return this.joinDot("form", fullFieldName.replaceAll("[.-]", "_"), field);
    }

    private String joinDot(String ... parts) {
        return Joiner.on((String)".").join((Object[])parts);
    }

    private HtmlElement createControls(Class<?> fieldType, AnnotatedElement annotatedElement, String fieldName, Class<?> entityType, String fullFieldName, BootstrapRenderingBuilder builder, String ... cssClasses) {
        return this.div(Arrays.asList("col-sm-6", this.isCheckbox(fieldType) ? "checkbox" : ""), this.createInput(fieldType, annotatedElement, fullFieldName, entityType, fieldName, builder, cssClasses), this.el("span", Arrays.asList("help-inline", this.bindServerErrorPath(fullFieldName, " ? '' : 'hide'")), this.text(this.bindServerErrorPath(fullFieldName, ""))));
    }

    private String lastNameElement(String[] splitted) {
        String lastNameElement = splitted[splitted.length - 1];
        if (lastNameElement.equals("id")) {
            lastNameElement = lastNameElement + StringUtils.capitalize((String)splitted[splitted.length - 2]);
        }
        return lastNameElement;
    }

    private boolean isCheckbox(Class<?> fieldType) {
        return Boolean.TYPE.isAssignableFrom(fieldType) || Boolean.class.isAssignableFrom(fieldType);
    }

    protected HtmlElement createSelect(String lastNameElement, String constantValues) {
        HtmlElement element = this.el("ui-select", Arrays.asList(""), this.el("ui-select-match", Arrays.asList(""), this.text("{{ formatElement($select.selected) }}")).attr("placeholder", "{{ options.placeholderText | translate }}"), this.el("ui-select-choices", Arrays.asList(""), this.div(Arrays.asList(""), new HtmlPart[0]).attr("ng-bind-html", "formatElement(item)")).attr("repeat", "item in " + constantValues + " | filter: $select.search").attr("refresh", "searchElements($select.search)")).attr("mt-select-options", this.joinDot(lastNameElement, "options")).attr("ng-disabled", this.joinDot(lastNameElement, "options.disabled"));
        return element;
    }

    private HtmlPart createInput(Class<?> fieldType, AnnotatedElement annotatedElement, String fullFieldName, Class<?> entityType, String fieldName, BootstrapRenderingBuilder builder, String ... cssClasses) {
        HtmlElement el;
        boolean addFormControlStyle = true;
        HtmlElement inputIfNotEl = null;
        String ngModel = fullFieldName;
        if (Enum.class.isAssignableFrom(fieldType)) {
            el = this.el("select", Arrays.asList(""), this.getEnumValuesElements(fieldType, !this.isAnnotationPresent(annotatedElement, NotNull.class)));
        } else if (Time.class.isAssignableFrom(fieldType)) {
            el = this.el("input", Arrays.asList("input-size-time", "timepicker"), new HtmlPart[0]).attr("type", "text").attr("placeholder", "HH:mm");
            this.pattern(el, "[0-2][0-9]:[0-5][0-9]");
        } else if (Date.class.isAssignableFrom(fieldType)) {
            el = this.el("input", Arrays.asList("input-size-date"), new HtmlPart[0]).attr("type", "text").attr("mt-datepicker", "datepickerOptions");
        } else if (this.isAnnotationPresent(annotatedElement, ManyToOne.class, EntityReference.class, OneToOne.class)) {
            String[] splitted = fullFieldName.split("[.]");
            String lastNameElement = this.lastNameElement(splitted);
            el = this.createSelect(lastNameElement, "$select.elements");
            if (fieldType.equals(Integer.class)) {
                ngModel = this.joinDot(lastNameElement, "value");
            }
            addFormControlStyle = false;
        } else if (this.isCheckbox(fieldType)) {
            inputIfNotEl = this.el("input", Arrays.asList(""), new HtmlPart[0]).attr("type", "checkbox");
            el = this.el("label", Arrays.asList(""), inputIfNotEl, this.text("&nbsp;"));
            addFormControlStyle = false;
        } else {
            el = this.el("input", Arrays.asList(""), new HtmlPart[0]).attr("type", "text");
            if (Number.class.isAssignableFrom(fieldType)) {
                this.pattern(el, "[0-9]+([.,][0-9]+)?");
            }
            if (this.isAnnotationPresent(annotatedElement, PasswordField.class)) {
                el.attr("type", "password");
            }
        }
        this.addFieldValidation(fieldType, entityType, el, fieldName);
        HtmlElement val = inputIfNotEl != null ? inputIfNotEl : el;
        val.attr("id", fullFieldName).attr("name", fullFieldName.replaceAll("\\.", "_")).attr("ng-model", ngModel).attr("placeholder", "{{ '" + fullFieldName + "' | translate }}").style(cssClasses);
        if (addFormControlStyle) {
            val.style("form-control");
        }
        if (builder != null) {
            for (String attr : builder.attributes.keySet()) {
                val.attr(attr, (String)builder.attributes.get(attr));
            }
        }
        return el;
    }

    private boolean isAnnotationPresent(AnnotatedElement annotatedElement, Class<? extends Annotation> ... annotations) {
        if (annotatedElement != null) {
            for (Class<? extends Annotation> annotation : annotations) {
                if (!annotatedElement.isAnnotationPresent(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    private void addFieldValidation(Class<?> fieldType, Class<?> entityType, HtmlElement el, String fieldName) {
        BeanDescriptor constraintsForClass;
        PropertyDescriptor constraintsForProperty;
        if (entityType == null) {
            return;
        }
        String propertyName = fieldName.substring(fieldName.lastIndexOf(".") + 1);
        if (fieldName.contains(".")) {
            entityType = ReflectUtil.getPropertyType(entityType, (String)fieldName.substring(0, fieldName.lastIndexOf(".")));
        }
        if ((constraintsForProperty = (constraintsForClass = this.validator.getConstraintsForClass(entityType)).getConstraintsForProperty(propertyName)) != null) {
            Set constraintDescriptors = constraintsForProperty.getConstraintDescriptors();
            for (ConstraintDescriptor constraintDescriptor : constraintDescriptors) {
                Pattern pattern;
                Annotation annotation = constraintDescriptor.getAnnotation();
                if (NotNull.class.isAssignableFrom(annotation.getClass())) {
                    el.attr("required", null);
                    continue;
                }
                if (Pattern.class.isAssignableFrom(annotation.getClass())) {
                    pattern = (Pattern)annotation;
                    this.pattern(el, pattern.regexp());
                    continue;
                }
                if (Digits.class.isAssignableFrom(annotation.getClass())) {
                    Digits digits = (Digits)annotation;
                    this.pattern(el, "[0-9]{" + digits.integer() + "}([.,][0-9]{" + digits.fraction() + "})?");
                    continue;
                }
                if (this.isAnnotatedAnnotation(annotation.getClass(), Pattern.class) == null) continue;
                pattern = this.isAnnotatedAnnotation(annotation.getClass(), Pattern.class);
                this.pattern(el, pattern.regexp());
            }
        }
    }

    private <A extends Annotation> A isAnnotatedAnnotation(Class<?> clazz, Class<A> annotation) {
        if (clazz.getAnnotation(annotation) != null) {
            return annotation.getClass().getAnnotation(annotation);
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (iface.getAnnotation(annotation) == null) continue;
            return iface.getAnnotation(annotation);
        }
        return null;
    }

    private void pattern(HtmlElement el, String pattern) {
        el.attr("ng-pattern", "/^(" + pattern + ")?$/");
    }

    private HtmlPart[] getEnumValuesElements(Class<? extends Enum<?>> propertyType, boolean withEmptyElement) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        if (withEmptyElement) {
            elements.add(this.el("option", Arrays.asList(""), new HtmlPart[0]));
        }
        for (Enum<?> enumElement : propertyType.getEnumConstants()) {
            elements.add(this.el("option", Arrays.asList(""), new HtmlPart[0]).attr("translate", this.joinDot("enum", propertyType.getSimpleName(), enumElement.toString())).attr("value", enumElement.name()));
        }
        return elements.toArray(new HtmlPart[0]);
    }

    public BootstrapRenderingBuilder create(Class<?> entityType) {
        return new BootstrapRenderingBuilder(entityType);
    }

    private String renderInlineFields(String[] fields, BootstrapRenderingBuilder builder) {
        ArrayList<HtmlPart> elements = new ArrayList<HtmlPart>();
        for (String fieldName : fields) {
            String fullFieldName = this.fullFieldName(builder.entityName, fieldName);
            String simpleElementName = (String)ArrayUtil.last((Object[])fieldName.split("[.]"));
            elements.add(this.el("span", Arrays.asList("inline-form-text", simpleElementName), new HtmlPart[0]).attr("translate", fullFieldName));
            elements.add(this.createInput(ReflectUtil.getPropertyType((Class)builder.entityType, (String)fieldName), ReflectUtil.getAnnotatedElement((Class)builder.entityType, (String)fieldName), fullFieldName, builder.entityType, "entity", builder, simpleElementName));
        }
        elements.remove(0);
        elements.add(this.el("span", Arrays.asList("help-inline"), this.text(this.bindServerErrorPath(builder.entityName, ""))));
        return this.createControlGroup(this.fullFieldName(builder.entityName, fields[0]), this.div(Arrays.asList("controls"), elements.toArray(new HtmlPart[0])));
    }

    public String renderSingleField(Class<?> fieldType, String fieldName, String ... cssClasses) {
        return this.renderField(fieldType, null, fieldName, this.create(null).cssClasses(cssClasses)) + "\n";
    }

    public String renderSingleField(Method method, String fieldName, String ... cssClasses) {
        return this.renderField(method.getReturnType(), method, fieldName, this.create(null).cssClasses(cssClasses)) + "\n";
    }

    private String fullFieldName(String entityName, String fieldName) {
        return (entityName != null ? Introspector.decapitalize(entityName) + "." : "") + fieldName;
    }

    public HtmlElement div(List<String> classes, HtmlPart ... innerElements) {
        return new HtmlElement("div", innerElements).style(classes);
    }

    public HtmlElement el(String element, List<String> classes, HtmlPart ... innerElements) {
        return new HtmlElement(element, innerElements).style(classes);
    }

    public HtmlText text(String text) {
        return new HtmlText(text);
    }

    public static BootstrapRenderer renderer() {
        return bootstrapRenderer;
    }

    public static class BootstrapRenderingBuilder {
        private Class<?> entityType;
        private String entityName = "entity";
        private boolean inline = false;
        private String[] cssClasses;
        private Map<String, String> attributes = new HashMap<String, String>();

        public BootstrapRenderingBuilder(Class<?> entityType) {
            this.entityType = entityType;
        }

        public BootstrapRenderingBuilder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public BootstrapRenderingBuilder inline(boolean inline) {
            this.inline = inline;
            return this;
        }

        public BootstrapRenderingBuilder cssClasses(String ... cssClasses) {
            this.cssClasses = cssClasses;
            return this;
        }

        public BootstrapRenderingBuilder attribute(String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        public String render(String ... fields) {
            if (this.inline) {
                return BootstrapRenderer.renderer().renderInlineFields(fields, this);
            }
            return Arrays.asList(fields).stream().reduce("", (sum, fieldName) -> sum + BootstrapRenderer.renderer().renderField(ReflectUtil.getPropertyType(this.entityType, (String)fieldName), ReflectUtil.getAnnotatedElement(this.entityType, (String)fieldName), (String)fieldName, this) + "\n");
        }

        public String renderWithName(String entityFieldName, String htmlFieldName) {
            return BootstrapRenderer.renderer().renderField(ReflectUtil.getPropertyType(this.entityType, (String)entityFieldName), ReflectUtil.getAnnotatedElement(this.entityType, (String)entityFieldName), htmlFieldName, this);
        }
    }
}

