/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import pl.matsuo.core.web.view.HtmlPart;

public class HtmlElement
extends HtmlPart {
    private final String element;
    private final HtmlPart[] innerElements;
    private final List<String> classes = new ArrayList<String>();
    private final Map<String, String> attributes = new TreeMap<String, String>();

    public HtmlElement(String element, HtmlPart ... innerElements) {
        this.element = element;
        this.innerElements = innerElements;
    }

    public HtmlElement style(String ... classes) {
        return this.style(Arrays.asList(classes));
    }

    public HtmlElement style(List<String> classes) {
        this.classes.addAll(classes);
        return this;
    }

    public HtmlElement attr(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    public String getAttr(String name) {
        return this.attributes.get(name);
    }

    public String toString() {
        String rendering = "<" + this.element;
        rendering = rendering + " class=\"";
        for (String clazz : this.classes) {
            rendering = rendering + " " + clazz;
        }
        rendering = rendering + "\"";
        for (String attrName : this.attributes.keySet()) {
            String value = this.attributes.get(attrName);
            rendering = rendering + " " + attrName + (value == null ? "" : "=\"" + this.attributes.get(attrName) + "\"");
        }
        rendering = rendering + ">\n";
        for (HtmlPart htmlPart : this.innerElements) {
            rendering = rendering + htmlPart.toString() + "\n";
        }
        rendering = rendering + "</" + this.element + ">";
        return rendering;
    }
}

