/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import pl.matsuo.core.exception.RestProcessingException;
import pl.matsuo.core.web.controller.exception.RestProcessingExceptionHandler;

@RunWith(value=SpringJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(classes={RestProcessingExceptionHandler.class, RpehTestConfiguration.class, RestProcessingExceptionThrowingController.class})
public class TestRestProcessingExceptionHandler {
    private MockMvc mockMvc;
    @Autowired
    WebApplicationContext wac;

    @Before
    public void setup() {
        this.mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.wac).build();
    }

    @Test
    public void testHandleException() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/tests/exception", (Object[])new Object[0])).andExpect(result -> result.getResponse().getContentAsString().contains("global_error_test")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @RestController
    @RequestMapping(value={"/tests"})
    public static class RestProcessingExceptionThrowingController {
        @RequestMapping(value={"/exception"}, method={RequestMethod.GET})
        public String find() {
            throw new RestProcessingException(new String[]{"global_error_test"});
        }
    }

    @Configuration
    @EnableWebMvc
    public static class RpehTestConfiguration {
    }
}

