/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.render;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.web.util.NestedServletException;
import pl.matsuo.core.web.controller.AbstractControllerRequestTest;
import pl.matsuo.core.web.controller.render.BootstrapRendererController;

@ContextConfiguration(classes={BootstrapRendererController.class})
public class TestBootstrapRendererControllerRequest
extends AbstractControllerRequestTest {
    private static final Logger logger = LoggerFactory.getLogger(TestBootstrapRendererControllerRequest.class);

    @Test
    public void testBasicEntityField() throws Exception {
        this.performAndCheck(MockMvcRequestBuilders.get((String)"/bootstrapRenderer", (Object[])new Object[0]).param("entityClass", new String[]{"pl.matsuo.core.model.organization.Person"}).param("fieldName", new String[]{"firstName"}), html -> Assert.assertTrue((boolean)html.contains("<input")));
    }

    @Test
    public void testCustomEntityName() throws Exception {
        this.performAndCheck(MockMvcRequestBuilders.get((String)"/bootstrapRenderer", (Object[])new Object[0]).param("entityClass", new String[]{"pl.matsuo.core.model.organization.Person"}).param("entityName", new String[]{"person"}).param("fieldName", new String[]{"firstName"}), html -> Assert.assertTrue((boolean)html.contains("<input")));
    }

    @Test
    public void testCustomHtmlFieldName() throws Exception {
        this.performAndCheck(MockMvcRequestBuilders.get((String)"/bootstrapRenderer", (Object[])new Object[0]).param("entityClass", new String[]{"pl.matsuo.core.model.organization.Person"}).param("fieldName", new String[]{"firstName"}).param("htmlName", new String[]{"formBaseName"}), html -> Assert.assertTrue((boolean)html.contains("<input")));
    }

    @Test(expected=NestedServletException.class)
    public void testCustomHtmlFieldName_toFix() throws Exception {
        this.performAndCheck(MockMvcRequestBuilders.get((String)"/bootstrapRenderer", (Object[])new Object[0]).param("entityClass", new String[]{"pl.matsuo.core.model.organization.Person"}).param("fieldName", new String[]{"firstName"}).param("htmlName", new String[]{"form.baseName"}), html -> Assert.assertTrue((boolean)html.contains("<input")));
    }

    @Test
    public void testWithAttributes() throws Exception {
        this.performAndCheck(MockMvcRequestBuilders.get((String)"/bootstrapRenderer", (Object[])new Object[0]).param("entityClass", new String[]{"pl.matsuo.core.model.organization.Person"}).param("fieldName", new String[]{"firstName"}).param("mtfNgDisabled", new String[]{"true"}).param("mtfCustomAttr", new String[]{"xxxy"}), html -> Assert.assertTrue((boolean)html.contains("<input")));
    }

    @Test
    public void testInline() throws Exception {
        this.performAndCheck(MockMvcRequestBuilders.get((String)"/bootstrapRenderer", (Object[])new Object[0]).param("entityClass", new String[]{"pl.matsuo.core.model.organization.Person"}).param("inline", new String[]{"true"}).param("fieldName", new String[]{"firstName"}), html -> Assert.assertTrue((boolean)html.contains("<input")));
    }

    @Test
    public void testSingleField() throws Exception {
        this.performAndCheck(MockMvcRequestBuilders.get((String)"/bootstrapRenderer", (Object[])new Object[0]).param("entityClass", new String[]{"pl.matsuo.core.model.organization.Person"}).param("singleField", new String[]{"true"}).param("fieldName", new String[]{"firstName"}), html -> Assert.assertTrue((boolean)html.contains("<input")));
    }
}

