/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.filter;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import pl.matsuo.core.conf.DbConfig;
import pl.matsuo.core.model.user.Group;
import pl.matsuo.core.model.user.User;
import pl.matsuo.core.service.permission.PermissionService;
import pl.matsuo.core.service.session.SessionState;
import pl.matsuo.core.test.data.TestSessionState;
import pl.matsuo.core.web.filter.PermissionsFilter;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={DbConfig.class, PermissionService.class, PermissionsFilter.class, TestSessionState.class})
public class TestPermissionsFilter {
    @Autowired
    PermissionsFilter permissionsFilter;
    @Autowired
    SessionState sessionState;

    @Test
    public void testPassLoggedOff() throws Exception {
        MockHttpServletRequest servletRequest = new MockHttpServletRequest("GET", "/index.html");
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        this.permissionsFilter.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse, filterChain);
        Assert.assertEquals((long)HttpStatus.OK.value(), (long)servletResponse.getStatus());
        ((FilterChain)Mockito.verify((Object)filterChain)).doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
    }

    @Test
    public void testRejectLoggedOff() throws Exception {
        MockHttpServletRequest servletRequest = new MockHttpServletRequest("GET", "/api/lists/AA");
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        this.permissionsFilter.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse, filterChain);
        Assert.assertEquals((long)HttpStatus.UNAUTHORIZED.value(), (long)servletResponse.getStatus());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{filterChain});
    }

    protected void configureSessionState(String groupName) {
        User user = new User();
        Group group = new Group();
        group.setName(groupName);
        user.getGroups().add(group);
        this.sessionState.setUser(user);
    }

    @Test
    @DirtiesContext
    public void testPassLoggedOn() throws Exception {
        this.configureSessionState("ADMIN");
        MockHttpServletRequest servletRequest = new MockHttpServletRequest("GET", "/api/lists/AA");
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        this.permissionsFilter.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse, filterChain);
        Assert.assertEquals((long)HttpStatus.OK.value(), (long)servletResponse.getStatus());
        ((FilterChain)Mockito.verify((Object)filterChain)).doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
    }

    @Test
    public void testRejectLoggedOn() throws Exception {
        this.configureSessionState("REGISTRATION");
        MockHttpServletRequest servletRequest = new MockHttpServletRequest("GET", "/api_xxx/lists/AA");
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        this.permissionsFilter.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse, filterChain);
        Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)servletResponse.getStatus());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{filterChain});
    }
}

