/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.login;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import pl.matsuo.core.conf.TestMailConfig;
import pl.matsuo.core.exception.RestProcessingException;
import pl.matsuo.core.exception.UnauthorizedException;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.organization.OrganizationUnit;
import pl.matsuo.core.model.organization.Person;
import pl.matsuo.core.model.organization.address.Address;
import pl.matsuo.core.model.query.Query;
import pl.matsuo.core.model.query.QueryBuilder;
import pl.matsuo.core.model.query.condition.QueryPart;
import pl.matsuo.core.model.user.Group;
import pl.matsuo.core.model.user.GroupEnum;
import pl.matsuo.core.model.user.User;
import pl.matsuo.core.service.login.CreateAccountData;
import pl.matsuo.core.service.login.ILoginServiceExtension;
import pl.matsuo.core.service.login.LoginData;
import pl.matsuo.core.service.login.LoginService;
import pl.matsuo.core.service.permission.PermissionService;
import pl.matsuo.core.web.controller.AbstractControllerTest;
import pl.matsuo.core.web.controller.login.LoginController;

@RunWith(value=SpringJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(classes={LoginController.class, LoginService.class, PermissionService.class, LoginServiceExtension.class, TestMailConfig.class})
public class TestLoginController
extends AbstractControllerTest {
    private static final Logger log = LoggerFactory.getLogger(TestLoginController.class);
    @Autowired
    LoginController controller;
    @Autowired
    LoginServiceExtension loginServiceExtension;

    @Test
    public void testLoggedUsername() {
        User user = new User();
        user.getGroups().add(new Group());
        this.sessionState.setUser(user);
        this.sessionState.getUser().setUsername("test_1");
        Assert.assertEquals((Object)"test_1", (Object)this.controller.loggedUsername());
    }

    @Test
    public void testCorrectLogin() {
        LoginData loginData = new LoginData();
        loginData.setUsername("admin");
        loginData.setPassword("6%86P#WnukNp2gBm");
        Assert.assertEquals((Object)"admin", (Object)this.controller.login(loginData));
        Assert.assertNotNull((Object)this.sessionState.getUser());
        Assert.assertEquals((Object)"admin", (Object)this.sessionState.getUser().getUsername());
    }

    @Test(expected=UnauthorizedException.class)
    public void testFalseLogin() {
        LoginData loginData = new LoginData();
        loginData.setUsername("test");
        loginData.setPassword("test");
        this.controller.login(loginData);
    }

    @Test
    public void testLogoff() {
        this.testCorrectLogin();
        this.controller.logoff();
        Assert.assertNull((Object)this.sessionState.getUser());
        Assert.assertTrue((boolean)this.sessionState.isInGroup(GroupEnum.GUEST.name()));
    }

    @Test
    public void testLoggedUser() {
        this.testCorrectLogin();
        Assert.assertTrue((boolean)this.sessionState.getUser().equals(this.controller.loggedUser()));
    }

    @Test
    public void testLoginTime() {
        this.testCorrectLogin();
        Assert.assertTrue((this.sessionState.getLastRequestTime() == this.sessionState.getLoginTime() ? 1 : 0) != 0);
    }

    @Test
    public void testActivateAccount() {
        CreateAccountData createAccountData = new CreateAccountData();
        createAccountData.setUsername("tristan");
        createAccountData.setPassword("tristan");
        createAccountData.setCompanyName("tristan");
        createAccountData.setCompanyShortName("tristan");
        createAccountData.setCompanyNip("692-000-00-13");
        String result = this.controller.createAccount(createAccountData);
        log.info(result);
        Assert.assertFalse((boolean)result.isEmpty());
        User user = (User)this.database.findOne((Query)QueryBuilder.query(User.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq(User::getUsername, (Object)"tristan")}));
        MockHttpServletResponse response = new MockHttpServletResponse();
        try {
            this.controller.activateAccount(user.getUnblockTicket(), (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        user = (User)this.database.findOne((Query)QueryBuilder.query(User.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq(User::getUsername, (Object)"tristan")}));
        Assert.assertFalse((boolean)user.getBlocked());
        Assert.assertNull((Object)user.getUnblockTicket());
        Assert.assertNotNull((Object)user.getIdBucket());
        this.checkEntitiesCountForBucket(user.getIdBucket(), 1, OrganizationUnit.class);
        this.checkEntitiesCountForBucket(user.getIdBucket(), 1, Person.class);
        this.checkEntitiesCountForBucket(user.getIdBucket(), 1, Address.class);
        try {
            response = new MockHttpServletResponse();
            this.controller.activateAccount(user.getUnblockTicket(), (HttpServletResponse)response);
        }
        catch (Exception e) {
            return;
        }
        Assert.fail();
    }

    protected void checkEntitiesCountForBucket(Long idBucket, Integer size, Class<? extends AbstractEntity> clazz) {
        List entities = this.database.find((Query)QueryBuilder.query(clazz, (QueryPart[])new QueryPart[]{QueryBuilder.eq(AbstractEntity::getIdBucket, (Object)idBucket)}));
        Assert.assertEquals((long)1L, (long)entities.size());
    }

    @Test
    public void testCreateAccount() {
        CreateAccountData createAccountData = new CreateAccountData();
        createAccountData.setUsername("kryspin");
        createAccountData.setPassword("kryspin");
        createAccountData.setCompanyName("kryspin");
        createAccountData.setCompanyShortName("kryspin");
        createAccountData.setCompanyNip("692-000-00-13");
        this.loginServiceExtension.counter = 0;
        String result = this.controller.createAccount(createAccountData);
        log.info(result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)this.loginServiceExtension.counter);
        try {
            this.controller.createAccount(createAccountData);
        }
        catch (RestProcessingException e) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testRemindPassword() {
    }

    static class LoginServiceExtension
    implements ILoginServiceExtension {
        public int counter = 0;

        LoginServiceExtension() {
        }

        public void createAccount(OrganizationUnit organizationUnit, User user) {
            ++this.counter;
        }
    }
}

