/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.login;

import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.web.util.NestedServletException;
import pl.matsuo.core.conf.TestMailConfig;
import pl.matsuo.core.exception.RestProcessingException;
import pl.matsuo.core.model.query.Query;
import pl.matsuo.core.model.query.QueryBuilder;
import pl.matsuo.core.model.query.condition.QueryPart;
import pl.matsuo.core.model.user.User;
import pl.matsuo.core.service.login.CreateAccountData;
import pl.matsuo.core.service.login.LoginData;
import pl.matsuo.core.service.login.LoginService;
import pl.matsuo.core.service.permission.PermissionService;
import pl.matsuo.core.web.controller.AbstractDbControllerRequestTest;
import pl.matsuo.core.web.controller.login.LoginController;

@RunWith(value=SpringJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(classes={LoginController.class, LoginService.class, PermissionService.class, TestMailConfig.class})
public class TestLoginControllerRequest
extends AbstractDbControllerRequestTest {
    @Autowired
    LoginController controller;

    @Test
    public void testActivateAccount() throws Exception {
        CreateAccountData createAccountData = new CreateAccountData();
        createAccountData.setUsername("kryspin");
        createAccountData.setPassword("kryspinx");
        createAccountData.setCompanyName("kryspin");
        createAccountData.setCompanyShortName("kryspin");
        createAccountData.setCompanyNip("692-000-00-13");
        this.performAndCheck(this.post("/login/createAccount", createAccountData), http -> Assert.assertFalse((boolean)http.isEmpty()));
        User user = (User)this.database.findOne((Query)QueryBuilder.query(User.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq(User::getUsername, (Object)"kryspin")}));
        try {
            this.performAndCheckStatus(MockMvcRequestBuilders.get((String)("/login/activateAccount/" + user.getUnblockTicket()), (Object[])new Object[0]), MockMvcResultMatchers.status().isFound(), new Consumer[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        user = (User)this.database.findOne((Query)QueryBuilder.query(User.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq(User::getUsername, (Object)"kryspin")}));
        Assert.assertFalse((boolean)user.getBlocked());
        Assert.assertNull((Object)user.getUnblockTicket());
        try {
            this.performAndCheck(MockMvcRequestBuilders.get((String)("/login/activateAccount/" + user.getUnblockTicket()), (Object[])new Object[0]), new Consumer[0]);
        }
        catch (NestedServletException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RestProcessingException));
            LoginData loginData = new LoginData();
            loginData.setUsername("kryspin");
            loginData.setPassword("kryspinx");
            this.performAndCheck(this.post("/login", loginData), reponse -> Assert.assertEquals((Object)reponse, (Object)"\"kryspin\""));
            return;
        }
        Assert.fail((String)"Should not come here");
    }
}

