/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.mvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;
import pl.matsuo.core.service.facade.FacadeBuilder;
import pl.matsuo.core.service.report.DataModelBuilder;
import pl.matsuo.core.web.mvc.FacadeBuilderHandlerMethodArgumentResolverTestController;
import pl.matsuo.core.web.mvc.MvcConfig;

@RunWith(value=SpringJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(classes={MvcConfig.class, FacadeBuilder.class, FacadeBuilderHandlerMethodArgumentResolverTestController.class})
public class TestFacadeBuilderHandlerMethodArgumentResolver {
    private MockMvc mockMvc;
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    WebApplicationContext wac;

    @Before
    public void setup() {
        this.mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.wac).build();
    }

    @Test
    public void testRequestParam() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/facadeBuilderHandlerMethodArgumentResolverTestController/requestParam", (Object[])new Object[0]).param("idTest", new String[]{"777"}).param("oneElementList", new String[]{"1"}).param("stringList", new String[]{"a"}).param("stringList", new String[]{"b"})).andExpect(MockMvcResultMatchers.status().isIAmATeapot());
    }

    @Test
    public void testRequestBody() throws Exception {
        Map dataModel = new DataModelBuilder().put("idTest", (Object)"777").put("oneElementList", Arrays.asList("1")).put("stringList", Arrays.asList("a", "b")).getDataModel();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/facadeBuilderHandlerMethodArgumentResolverTestController/requestBody", (Object[])new Object[0]).content(this.objectMapper.writeValueAsString((Object)dataModel))).andExpect(MockMvcResultMatchers.status().isIAmATeapot());
    }

    @Test
    public void testParameterProvider() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/facadeBuilderHandlerMethodArgumentResolverTestController/parameterProvider", (Object[])new Object[0]).param("idTest", new String[]{"777"})).andExpect(MockMvcResultMatchers.status().isIAmATeapot());
    }
}

