/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.hibernate.criterion.MatchMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.api.Initializer;
import pl.matsuo.core.model.query.AbstractQuery;
import pl.matsuo.core.model.query.QueryBuilder;
import pl.matsuo.core.model.query.condition.Condition;
import pl.matsuo.core.model.query.condition.FieldCondition;
import pl.matsuo.core.model.query.condition.QueryPart;
import pl.matsuo.core.params.IQueryRequestParams;
import pl.matsuo.core.service.db.Database;
import pl.matsuo.core.service.facade.IFacadeBuilder;
import pl.matsuo.core.util.ReflectUtil;
import pl.matsuo.core.util.StringUtil;

@Transactional
public abstract class AbstractSearchController<E extends AbstractEntity, P extends IQueryRequestParams> {
    @Autowired
    protected Database database;
    @Autowired
    protected IFacadeBuilder facadeBuilder;
    protected final Class<E> entityType = ReflectUtil.resolveType(this.getClass(), AbstractSearchController.class, (int)0);
    protected final Initializer<E>[] entityInitializers = this.entityInitializers().toArray(new Initializer[0]);

    protected <F extends AbstractEntity> List<Function<F, String>> queryMatchers(Class<F> entity) {
        if (entity.equals(this.entityType)) {
            return this.queryMatchers();
        }
        throw new RuntimeException("Custom entity type requires queryMatchers(Class) redefinition");
    }

    protected List<Function<E, String>> queryMatchers() {
        return Collections.emptyList();
    }

    protected <F extends AbstractEntity> AbstractQuery<F> listQuery(Class<F> entity, P params, List<Function<F, String>> queryMatchers, Condition ... additionalConditions) {
        ArrayList<Condition> conditions = new ArrayList<Condition>(Arrays.asList(additionalConditions));
        if (StringUtil.notEmpty((String)params.getQuery())) {
            String[] parts;
            if (queryMatchers.isEmpty()) {
                throw new IllegalStateException("When using query parameter queryMatchers must be defined");
            }
            for (String part : parts = params.getQuery().split(" ")) {
                ArrayList<FieldCondition> partConditions = new ArrayList<FieldCondition>();
                for (Function<F, String> queryMatcher : queryMatchers) {
                    partConditions.add(QueryBuilder.ilike(queryMatcher, (Object)part.trim(), (MatchMode)MatchMode.ANYWHERE));
                }
                conditions.add(QueryBuilder.or((Condition[])partConditions.toArray(new Condition[0])));
            }
        }
        return this.entityQuery(entity, conditions.toArray(new Condition[0]));
    }

    protected <F extends AbstractEntity> AbstractQuery<F> listQuery(Class<F> entity, P params, Condition ... additionalConditions) {
        return this.listQuery(entity, params, this.queryMatchers(entity), additionalConditions);
    }

    protected AbstractQuery<E> listQuery(P params, Condition ... additionalConditions) {
        return this.listQuery(this.entityType, params, this.queryMatchers(), additionalConditions);
    }

    protected <F extends AbstractEntity> List<F> list(Class<F> entity, P params) {
        AbstractQuery<F> query = this.listQuery(entity, params, new Condition[0]);
        if (params.getLimit() != null && params.getLimit() > 0) {
            query.limit(params.getLimit());
        }
        if (params.getOffset() != null && params.getOffset() > 0) {
            query.offset(params.getOffset());
        }
        List list = this.database.find(query);
        return list;
    }

    @RequestMapping(method={RequestMethod.GET})
    public List<E> list(P params) {
        return this.list(this.entityType, params);
    }

    protected List<E> list(Condition ... conditions) {
        return this.database.find(this.entityQuery(this.entityType, conditions));
    }

    protected <F extends AbstractEntity> AbstractQuery<F> entityQuery(Class<F> entity, Condition ... conditions) {
        return QueryBuilder.query(entity, (QueryPart[])conditions).initializer(this.entityInitializers);
    }

    @RequestMapping(value={"/list/byIds"}, method={RequestMethod.GET}, consumes={"application/octet-stream"})
    public List<E> listByIds(@RequestParam(value="ids") List<Long> ids) {
        return this.database.find(this.entityQuery(this.entityType, new Condition[]{QueryBuilder.in(AbstractEntity::getId, ids)}));
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public HttpEntity<E> find(@PathVariable(value="id") Long id) {
        try {
            return new HttpEntity((Object)this.database.findById(this.entityType, id, this.entityInitializers));
        }
        catch (IllegalArgumentException e) {
            throw new EntityNotFoundException(id);
        }
    }

    protected List<? extends Initializer<? super E>> entityInitializers() {
        return new ArrayList();
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public void setFacadeBuilder(IFacadeBuilder facadeBuilder) {
        this.facadeBuilder = facadeBuilder;
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public static class EntityNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public EntityNotFoundException(Long id) {
            super("Entity '" + id + "' not found.");
        }
    }
}

