/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.message;

import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.message.AbstractMessage;
import pl.matsuo.core.model.organization.AbstractParty;
import pl.matsuo.core.model.query.AbstractQuery;
import pl.matsuo.core.model.query.QueryBuilder;
import pl.matsuo.core.model.query.condition.Condition;
import pl.matsuo.core.model.query.condition.QueryPart;
import pl.matsuo.core.model.user.Group;
import pl.matsuo.core.service.user.IGroupsService;
import pl.matsuo.core.web.controller.AbstractController;
import pl.matsuo.core.web.controller.message.IMessageRequestParams;
import pl.matsuo.core.web.controller.message.MultiMessage;
import pl.matsuo.core.web.controller.organization.SimpleParty;

public abstract class AbstractMessageController<E extends AbstractMessage>
extends AbstractController<E, IMessageRequestParams> {
    @Autowired
    protected IGroupsService groupsService;

    @RequestMapping(value={"/multiMessage"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void create(@RequestBody @Valid MultiMessage<E> entity, @Value(value="#{request.requestURL}") StringBuffer parentUri) {
        for (SimpleParty simpleParty : entity.getParties()) {
            E smsMessage = this.copyMessage(entity.getMessage());
            if (AbstractParty.class.isAssignableFrom(simpleParty.getType())) {
                smsMessage.setIdParty(simpleParty.getId());
                this.database.create(smsMessage);
                continue;
            }
            if (!Group.class.isAssignableFrom(simpleParty.getType())) continue;
            throw new RuntimeException("Not implemented yet");
        }
    }

    protected abstract E copyMessage(E var1);

    @Override
    protected <F extends AbstractEntity> AbstractQuery<F> listQuery(Class<F> entity, IMessageRequestParams params, Condition ... additionalConditions) {
        return super.listQuery(entity, params, additionalConditions).parts(new QueryPart[]{QueryBuilder.eq(AbstractMessage::getIdParty, (Object)params.getIdParty())});
    }
}

