/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.organization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.organization.AbstractParty;
import pl.matsuo.core.model.organization.OrganizationUnit;
import pl.matsuo.core.model.organization.Person;
import pl.matsuo.core.params.IQueryRequestParams;
import pl.matsuo.core.util.ComparatorUtil;
import pl.matsuo.core.web.controller.AbstractSearchController;

@RestController
@RequestMapping(value={"/payers"})
public class PayerController
extends AbstractSearchController<AbstractParty, IQueryRequestParams> {
    @Override
    protected <F extends AbstractEntity> List<Function<F, String>> queryMatchers(Class<F> entity) {
        if (Person.class.equals(entity)) {
            List<Function<F, String>> result = Arrays.asList(Person::getFirstName, Person::getLastName);
            return result;
        }
        if (OrganizationUnit.class.equals(entity)) {
            List<Function<F, String>> result = Arrays.asList(OrganizationUnit::getFullName, OrganizationUnit::getShortName, OrganizationUnit::getCode);
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    @RequestMapping(method={RequestMethod.GET})
    public List<AbstractParty> list(IQueryRequestParams params) {
        List<Person> persons = super.list(Person.class, params);
        List<OrganizationUnit> companies = super.list(OrganizationUnit.class, params);
        ArrayList<AbstractParty> parties = new ArrayList<AbstractParty>();
        parties.addAll(persons);
        parties.addAll(companies);
        parties.sort(ComparatorUtil.comparator((Function[])new Function[]{AbstractParty::getName}));
        return parties;
    }
}

