/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.print;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.GenericTypeResolver;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.api.Initializer;
import pl.matsuo.core.model.print.IPrintFacade;
import pl.matsuo.core.model.print.KeyValuePrint;
import pl.matsuo.core.model.print.initializer.PrintInitializer;
import pl.matsuo.core.model.query.Query;
import pl.matsuo.core.model.query.QueryBuilder;
import pl.matsuo.core.model.query.condition.Condition;
import pl.matsuo.core.model.query.condition.QueryPart;
import pl.matsuo.core.model.report.IPrintsReportParams;
import pl.matsuo.core.service.db.Database;
import pl.matsuo.core.service.facade.IFacadeBuilder;
import pl.matsuo.core.service.print.AbstractPrintService;
import pl.matsuo.core.service.print.IPrintsRendererService;

@RestController
@Transactional
@RequestMapping(value={"/prints"})
public class PrintController {
    @Autowired
    protected Database database;
    @Autowired
    protected IPrintsRendererService printsRendererService;
    @Autowired
    protected IFacadeBuilder facadeBuilder;
    Map<Class, AbstractPrintService> reportServicesMap;

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public void generatePrint(@PathVariable(value="id") Long id, HttpServletResponse response) {
        try {
            KeyValuePrint print = (KeyValuePrint)this.database.findById(KeyValuePrint.class, id, new Initializer[]{new PrintInitializer()});
            if (print == null) {
                response.sendError(404);
                return;
            }
            this.generatePrint(print, response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void generatePrint(KeyValuePrint print, HttpServletResponse response) {
        try {
            AbstractPrintService printService = this.reportServicesMap.get(print.getPrintClass());
            if (printService == null) {
                throw new IllegalArgumentException("Unknown report " + print.getPrintClass());
            }
            IPrintFacade printFacade = (IPrintFacade)this.facadeBuilder.createFacade((Object)print, print.getPrintClass());
            Map model = printService.buildModel(printFacade);
            model.put("outputFormat", "pdf");
            this.generatePrint(StringUtils.uncapitalize((String)print.getPrintClass().getSimpleName()) + ".ftl", printService.getFileName(printFacade), model, response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected List<KeyValuePrint> findPrints(IPrintsReportParams params, String personProperty, QueryPart ... queryParts) {
        return this.database.find((Query)QueryBuilder.query(KeyValuePrint.class, (QueryPart[])new QueryPart[]{QueryBuilder.select((String[])new String[]{"keyValuePrint"}), QueryBuilder.maybe((Object)params.getIdPatient(), (Condition)QueryBuilder.cond((String)(personProperty + " = " + params.getIdPatient()))), QueryBuilder.maybe((Object)params.getIdPayer(), (Condition)QueryBuilder.cond((String)("keyValuePrint.fields['buyer.id'] = " + params.getIdPayer()))), QueryBuilder.maybe((Object)params.getStartDate(), (Condition)QueryBuilder.ge(AbstractEntity::getCreatedTime, (Object)params.getStartDate())), QueryBuilder.maybe((Object)params.getEndDate(), (Condition)QueryBuilder.le(AbstractEntity::getCreatedTime, (Object)params.getEndDate())), QueryBuilder.maybeEq((Object)params.getPrintClass(), KeyValuePrint::getPrintClass)}).parts(queryParts).initializer(new Initializer[]{new PrintInitializer()}));
    }

    @RequestMapping(method={RequestMethod.GET})
    public List<KeyValuePrint> list(IPrintsReportParams params) {
        List<KeyValuePrint> prints2 = this.findPrints(params, "keyValuePrint.fields['buyer.id']", new QueryPart[0]);
        List<KeyValuePrint> prints = this.findPrints(params, "keyValuePrint.idEntity", new QueryPart[0]);
        HashMap printsMap = new HashMap();
        Arrays.asList(prints, prints2).forEach(collection -> collection.forEach(print -> printsMap.put(print.getId(), print)));
        List<Object> result = new ArrayList<KeyValuePrint>(printsMap.values());
        Collections.sort(result, (a, b) -> b.getCreatedTime().compareTo(a.getCreatedTime()));
        if (params.getLimit() != null) {
            result = result.subList(0, params.getLimit());
        }
        return result;
    }

    public void generatePrint(String templateName, String fileName, Object dataModel, HttpServletResponse response) {
        byte[] pdf = this.printsRendererService.generatePrint(templateName, dataModel);
        response.setContentType("application/pdf");
        response.setContentLength(pdf.length);
        response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        try {
            IOUtils.write((byte[])pdf, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/list/byIdEntities"}, method={RequestMethod.GET}, consumes={"application/octet-stream"})
    public List<KeyValuePrint> listByIdEntities(@RequestParam(value="ids") List<Long> ids) {
        return this.database.find((Query)QueryBuilder.query(KeyValuePrint.class, (QueryPart[])new QueryPart[]{QueryBuilder.in(KeyValuePrint::getIdEntity, ids)}).initializer(new Initializer[]{new PrintInitializer()}));
    }

    @Autowired(required=false)
    public void setReportServices(AbstractPrintService[] reportServices) {
        this.reportServicesMap = new HashMap<Class, AbstractPrintService>();
        for (AbstractPrintService reportService : reportServices) {
            this.reportServicesMap.put(GenericTypeResolver.resolveTypeArgument(reportService.getClass(), AbstractPrintService.class), reportService);
        }
    }
}

