/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.log.AccessLog;
import pl.matsuo.core.service.permission.PermissionService;
import pl.matsuo.core.web.filter.AbstractFilter;

@Component(value="accessLogFilter")
public class AccessLogFilter
extends AbstractFilter {
    @Autowired
    PermissionService permissionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        AccessLog accessLog = new AccessLog();
        accessLog.setIp(request.getRemoteAddr());
        accessLog.setRequest(request.getRequestURI());
        accessLog.setMethod(request.getMethod());
        if (request.getMethod().equalsIgnoreCase("get") && !request.getParameterMap().keySet().isEmpty()) {
            accessLog.setParameters(request.getParameterMap().toString());
        }
        if (this.sessionState.getUser() != null) {
            accessLog.setIdUser(this.sessionState.getUser().getId());
        }
        this.database.create((AbstractEntity)accessLog);
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            accessLog.setStatus(Integer.valueOf(response.getStatus()));
            try {
                if (response.getStatus() >= 300 && response.getStatus() < 400) {
                    this.database.delete((AbstractEntity)accessLog);
                } else {
                    this.database.update((AbstractEntity)accessLog);
                }
            }
            catch (RuntimeException runtimeException) {}
        }
    }
}

