/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import pl.matsuo.core.service.permission.IPermissionService;
import pl.matsuo.core.service.permission.PermissionService;
import pl.matsuo.core.web.filter.AbstractFilter;

@Component(value="permissionsFilter")
public class PermissionsFilter
extends AbstractFilter {
    @Autowired
    PermissionService permissionService;

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.permissionService.isPermitted(request.getRequestURI(), IPermissionService.RequestType.valueOf((String)request.getMethod()))) {
            System.out.println("no permissions to: " + request.getRequestURI());
            response.setStatus(this.sessionState.getUser() == null ? HttpStatus.UNAUTHORIZED.value() : HttpStatus.FORBIDDEN.value());
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

