/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.mvc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import pl.matsuo.core.web.annotation.WebConfiguration;
import pl.matsuo.core.web.mvc.CustomDateFormat;
import pl.matsuo.core.web.mvc.CustomJacksonModule;
import pl.matsuo.core.web.mvc.FacadeBuilderHandlerMethodArgumentResolver;
import pl.matsuo.core.web.view.BootstrapRenderer;

@WebConfiguration
@Configuration
@Import(value={BootstrapRenderer.class, FacadeBuilderHandlerMethodArgumentResolver.class})
public class MvcConfig
extends WebMvcConfigurationSupport
implements ApplicationListener<ContextRefreshedEvent> {
    public void onApplicationEvent(ContextRefreshedEvent event) {
        RequestMappingHandlerAdapter adapter = (RequestMappingHandlerAdapter)event.getApplicationContext().getBean(RequestMappingHandlerAdapter.class);
        try {
            FacadeBuilderHandlerMethodArgumentResolver facadeBuilderHandlerMethodArgumentResolver = (FacadeBuilderHandlerMethodArgumentResolver)event.getApplicationContext().getBean(FacadeBuilderHandlerMethodArgumentResolver.class);
            ArrayList<FacadeBuilderHandlerMethodArgumentResolver> argumentResolvers = new ArrayList<FacadeBuilderHandlerMethodArgumentResolver>(adapter.getArgumentResolvers());
            adapter.getCustomArgumentResolvers();
            argumentResolvers.remove(facadeBuilderHandlerMethodArgumentResolver);
            argumentResolvers.add(0, facadeBuilderHandlerMethodArgumentResolver);
            adapter.setArgumentResolvers(argumentResolvers);
        }
        catch (BeansException beansException) {
            // empty catch block
        }
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.converter());
        converters.add((HttpMessageConverter<?>)this.stringHttpMessageConverter());
        this.addDefaultHttpMessageConverters(converters);
    }

    private StringHttpMessageConverter stringHttpMessageConverter() {
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter();
        stringConverter.setSupportedMediaTypes(Arrays.asList(new MediaType("text", "plain", StandardCharsets.UTF_8)));
        stringConverter.setSupportedMediaTypes(Arrays.asList(new MediaType("text", "html", StandardCharsets.UTF_8)));
        return stringConverter;
    }

    @Bean
    public ObjectMapper objectMapper(MappingJackson2HttpMessageConverter converter) {
        return converter.getObjectMapper();
    }

    @Bean
    public MappingJackson2HttpMessageConverter converter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        ObjectMapper objectMapper = converter.getObjectMapper();
        objectMapper.setDateFormat((DateFormat)((Object)new CustomDateFormat()));
        objectMapper.registerModule((Module)new CustomJacksonModule());
        objectMapper.registerModule((Module)new Hibernate5Module());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return converter;
    }

    @Bean
    public CommonsMultipartResolver multipartResolver() {
        return new CommonsMultipartResolver();
    }
}

