/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.request;

import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.view.RedirectView;

@Service
public class RequestContextService {
    ThreadLocal<HttpServletRequest> requestThreadLocal = new ThreadLocal();

    public String getContextPath() {
        HttpServletRequest httpServletRequest = this.requestThreadLocal.get();
        return httpServletRequest != null ? httpServletRequest.getContextPath() : "/";
    }

    public String getPathInfo() {
        HttpServletRequest httpServletRequest = this.requestThreadLocal.get();
        return httpServletRequest != null ? httpServletRequest.getPathInfo() : "/";
    }

    public void setRequest(HttpServletRequest request) {
        this.requestThreadLocal.set(request);
    }

    public void clearRequest() {
        this.requestThreadLocal.remove();
    }

    public String href(String path) {
        return this.getContextPath() + path;
    }

    public RedirectView redirect(String path) {
        return new RedirectView(this.getContextPath() + path);
    }
}

