/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import pl.matsuo.core.model.api.Initializer;
import pl.matsuo.core.model.query.AbstractQuery;
import pl.matsuo.core.model.query.condition.Condition;
import pl.matsuo.core.model.user.User;
import pl.matsuo.core.params.IQueryRequestParams;
import pl.matsuo.core.service.db.Database;
import pl.matsuo.core.web.controller.AbstractController;

public class TestAbstractController {
    Database database = (Database)Mockito.mock(Database.class);
    AbstractController controller = new AbstractController<User, IQueryRequestParams>(){

        protected List<Function<User, String>> queryMatchers() {
            return Arrays.asList(User::getUsername, User::getPassword);
        }

        protected List<? extends Initializer<? super User>> entityInitializers() {
            return Arrays.asList(user -> user.setUsername("tester"));
        }
    };

    @Before
    public void setup() {
        this.controller.database = this.database;
    }

    @Test
    public void testListQuery() {
        IQueryRequestParams params = (IQueryRequestParams)Mockito.mock(IQueryRequestParams.class);
        Mockito.when((Object)params.getQuery()).thenReturn((Object)"some text");
        AbstractQuery query = this.controller.listQuery(params, new Condition[]{q -> "test string"});
        Assert.assertEquals((Object)"FROM pl.matsuo.core.model.user.User user WHERE test string AND (lower(username) like '%some%' OR lower(password) like '%some%') AND (lower(username) like '%text%' OR lower(password) like '%text%')", (Object)query.printQuery());
    }

    @Test
    public void testList() {
        IQueryRequestParams params = (IQueryRequestParams)Mockito.mock(IQueryRequestParams.class);
        Mockito.when((Object)params.getQuery()).thenReturn((Object)"some text");
        Mockito.when((Object)this.database.find((pl.matsuo.core.model.query.Query)ArgumentMatchers.any(pl.matsuo.core.model.query.Query.class))).then(invocation -> {
            AbstractQuery query = (AbstractQuery)invocation.getArguments()[0];
            Assert.assertEquals((Object)"FROM pl.matsuo.core.model.user.User user WHERE (lower(username) like '%some%' OR lower(password) like '%some%') AND (lower(username) like '%text%' OR lower(password) like '%text%')", (Object)query.printQuery());
            return Collections.nCopies(100, new User());
        });
        Assert.assertEquals((long)100L, (long)this.controller.list(params).size());
    }

    @Test
    public void testList_limitAndOffset() {
        IQueryRequestParams params = (IQueryRequestParams)Mockito.mock(IQueryRequestParams.class);
        Mockito.when((Object)params.getQuery()).thenReturn((Object)"some text");
        Mockito.when((Object)params.getLimit()).thenReturn((Object)20);
        Mockito.when((Object)params.getOffset()).thenReturn((Object)10);
        Mockito.when((Object)this.database.find((pl.matsuo.core.model.query.Query)ArgumentMatchers.any(pl.matsuo.core.model.query.Query.class))).then(invocation -> {
            EntityManager entityManager = (EntityManager)Mockito.mock(EntityManager.class);
            Query jpaQuery = (Query)Mockito.mock(Query.class);
            Session session = (Session)Mockito.mock(Session.class);
            Mockito.when((Object)entityManager.createQuery(ArgumentMatchers.anyString())).thenReturn((Object)jpaQuery);
            AbstractQuery query = (AbstractQuery)invocation.getArguments()[0];
            Field field = query.getClass().getDeclaredField("entityManager");
            try {
                field.setAccessible(true);
                field.set(query, entityManager);
            }
            finally {
                field.setAccessible(false);
            }
            query.query(null);
            ((Query)Mockito.verify((Object)jpaQuery)).setMaxResults(20);
            ((Query)Mockito.verify((Object)jpaQuery)).setFirstResult(10);
            return Collections.nCopies(5, new User());
        });
        Assert.assertEquals((long)5L, (long)this.controller.list(params).size());
    }

    @Test
    public void testList1() {
        Mockito.when((Object)this.database.find((pl.matsuo.core.model.query.Query)ArgumentMatchers.any(pl.matsuo.core.model.query.Query.class))).then(invocation -> {
            AbstractQuery query = (AbstractQuery)invocation.getArguments()[0];
            Assert.assertEquals((Object)"FROM pl.matsuo.core.model.user.User user WHERE test_x AND test_y", (Object)query.printQuery());
            return Collections.nCopies(33, new User());
        });
        Assert.assertEquals((long)33L, (long)this.controller.list(new Condition[]{q -> "test_x", q -> "test_y"}).size());
    }

    @Test
    public void testEntityQuery() {
        Assert.assertEquals((Object)"FROM pl.matsuo.core.model.user.User user WHERE test_x AND test_y", (Object)this.controller.entityQuery(User.class, new Condition[]{q -> "test_x", q -> "test_y"}).printQuery());
    }

    @Test
    public void testListByIds() {
        Mockito.when((Object)this.database.find((pl.matsuo.core.model.query.Query)ArgumentMatchers.any(pl.matsuo.core.model.query.Query.class))).then(invocation -> {
            AbstractQuery query = (AbstractQuery)invocation.getArguments()[0];
            Assert.assertEquals((Object)"FROM pl.matsuo.core.model.user.User user WHERE id in (1, 2, 3)", (Object)query.printQuery());
            return Collections.nCopies(3, new User());
        });
        Assert.assertEquals((long)3L, (long)this.controller.listByIds(Arrays.asList(1, 2, 3)).size());
    }

    @Test
    public void testFind() {
        User user = new User();
        Mockito.when((Object)this.database.findById((Class)ArgumentMatchers.any(Class.class), (Long)ArgumentMatchers.any(Long.class), new Initializer[]{(Initializer)ArgumentMatchers.any(Initializer.class)})).thenReturn((Object)user);
        Assert.assertTrue((this.controller.find(Long.valueOf(7L)).getBody() == user ? 1 : 0) != 0);
    }

    @Test
    public void testEntityInitializers() {
        Mockito.when((Object)this.database.findById((Class)ArgumentMatchers.any(Class.class), (Long)ArgumentMatchers.any(Long.class), new Initializer[]{(Initializer)ArgumentMatchers.any(Initializer.class)})).then(invocation -> {
            Assert.assertEquals((long)3L, (long)invocation.getArguments().length);
            Initializer initializer = (Initializer)invocation.getArguments()[2];
            User user = new User();
            initializer.init((Object)user);
            Assert.assertEquals((Object)"tester", (Object)user.getUsername());
            return user;
        });
        Assert.assertEquals((Object)"tester", (Object)((User)this.controller.find(Long.valueOf(7L)).getBody()).getUsername());
    }

    @Test
    public void testCreate() {
    }

    @Test
    public void testUpdate() {
    }

    @Test
    public void testDelete() {
    }

    @Test
    public void testUpdate1() {
    }

    @Test
    public void testChildLocation() {
    }

    @Test
    public void testHttpEntity() {
    }
}

