/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.render;

import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import pl.matsuo.core.service.parameterprovider.IParameterProvider;
import pl.matsuo.core.util.StringUtil;
import pl.matsuo.core.web.controller.render.IBootstrapRendererRequestParams;
import pl.matsuo.core.web.view.BootstrapRenderer;

@RestController
@Transactional
@RequestMapping(value={"/bootstrapRenderer"})
public class BootstrapRendererController {
    @RequestMapping(method={RequestMethod.GET})
    public String renderedField(IBootstrapRendererRequestParams requestParams, IParameterProvider<Map<String, List<String>>> params) throws ClassNotFoundException {
        if (requestParams.getSingleField() != null) {
            return BootstrapRenderer.renderer().renderSingleField(Class.forName(requestParams.getEntityClass()), requestParams.getFieldName(), requestParams.getCssClasses());
        }
        BootstrapRenderer.BootstrapRenderingBuilder builder = BootstrapRenderer.renderer().create(Class.forName(requestParams.getEntityClass()));
        if (requestParams.getInline() != null) {
            builder = builder.inline(true);
        }
        if (requestParams.getEntityName() != null) {
            builder = builder.entityName(requestParams.getEntityName());
        }
        if (requestParams.getCssClasses() != null) {
            builder = builder.cssClasses(requestParams.getCssClasses().split(" "));
        }
        Map rawParams = (Map)params.getUnderlyingEntity();
        for (String key : rawParams.keySet()) {
            if (!key.startsWith("mtf")) continue;
            String attrName = StringUtil.camelCaseToCssName((String)key.substring(3));
            builder = builder.attribute(attrName, (String)((List)rawParams.get(key)).get(0));
        }
        return requestParams.getHtmlName() != null ? builder.renderWithName(requestParams.getFieldName(), requestParams.getHtmlName()) : builder.render(requestParams.getFieldName());
    }
}

