/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.report;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.GenericTypeResolver;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pl.matsuo.core.service.db.Database;
import pl.matsuo.core.service.facade.IFacadeBuilder;
import pl.matsuo.core.service.print.IPrintsRendererService;
import pl.matsuo.core.service.report.IReportService;
import pl.matsuo.core.util.ReflectCollectionUtil;

@RestController
@Transactional
@RequestMapping(value={"/reports"})
public class ReportsController {
    @Autowired
    Database database;
    @Autowired
    IPrintsRendererService printsRendererService;
    @Autowired
    IFacadeBuilder facadeBuilder;
    Map<String, IReportService> reportServicesMap;

    @RequestMapping(value={"/pdf/{reportName}"}, method={RequestMethod.GET})
    public void generateReportPdf(@PathVariable(value="reportName") String reportName, @RequestParam Map<String, String> params, HttpServletResponse response) {
        this.generateReport("pdf", "application/pdf", (arg_0, arg_1) -> ((IPrintsRendererService)this.printsRendererService).generatePrint(arg_0, arg_1), reportName, params, response);
    }

    @RequestMapping(value={"/xls/{reportName}"}, method={RequestMethod.GET})
    public void generateReportXls(@PathVariable(value="reportName") String reportName, @RequestParam Map<String, String> params, HttpServletResponse response) {
        this.generateReport("xls", "application/vnd.ms-excel", (arg_0, arg_1) -> ((IPrintsRendererService)this.printsRendererService).renderHtml(arg_0, arg_1), reportName, params, response);
    }

    protected <E> void generateReport(String outputType, String contentType, BiFunction<String, Object, byte[]> method, String reportName, Map<String, String> params, HttpServletResponse response) {
        try {
            IReportService reportService = this.reportServicesMap.get(reportName);
            if (reportService == null) {
                throw new IllegalArgumentException("Unknown report " + reportName);
            }
            Map model = reportService.buildModel(this.facadeBuilder.createFacade(params, GenericTypeResolver.resolveTypeArgument(reportService.getClass(), IReportService.class)));
            model.put("outputFormat", outputType);
            String templateName = reportService.getTemplateName() + ".ftl";
            byte[] html = method.apply(templateName, model);
            response.setContentType(contentType);
            response.setContentLength(html.length);
            response.addHeader("Content-Disposition", "attachment; filename=\"" + reportName + "." + outputType + "\"");
            IOUtils.write((byte[])html, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while generating report " + reportName + " for outputType " + outputType, e);
        }
    }

    @Autowired(required=false)
    public void setReportServices(IReportService[] reportServices) {
        this.reportServicesMap = ReflectCollectionUtil.toMap(Arrays.asList(reportServices), (String)"defaultTemplateName");
    }
}

