/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.user;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import pl.matsuo.core.exception.RestProcessingException;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.api.Initializer;
import pl.matsuo.core.model.organization.Person;
import pl.matsuo.core.model.query.QueryBuilder;
import pl.matsuo.core.model.user.User;
import pl.matsuo.core.model.user.initializer.UserInitializer;
import pl.matsuo.core.service.session.SessionState;
import pl.matsuo.core.util.SecurityUtil;
import pl.matsuo.core.web.controller.AbstractSimpleController;
import pl.matsuo.core.web.controller.user.IBlockUserParams;
import pl.matsuo.core.web.controller.user.IChangePasswordParams;

@RestController
@RequestMapping(value={"/users"})
public class UserController
extends AbstractSimpleController<User> {
    @Autowired
    protected SessionState sessionState;
    protected Integer minimalPasswordLength = 8;

    @Override
    protected List<Function<User, String>> queryMatchers() {
        return Arrays.asList(User::getUsername, QueryBuilder.sub(User::getPerson, Person::getFirstName), QueryBuilder.sub(User::getPerson, Person::getLastName));
    }

    @Override
    protected List<? extends Initializer<User>> entityInitializers() {
        return Arrays.asList(new UserInitializer());
    }

    @Override
    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public HttpEntity<User> create(@RequestBody @Valid User entity, @Value(value="#{request.requestURL}") StringBuffer parentUri) {
        Person person = (Person)this.database.create((AbstractEntity)entity.getPerson());
        entity.setPerson(person);
        if (entity.getPassword().length() < this.minimalPasswordLength) {
            throw new RestProcessingException(new String[]{"password_too_short"});
        }
        entity.setPassword(SecurityUtil.passwordHash((String)entity.getPassword()));
        entity = (User)this.database.create((AbstractEntity)entity);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.childLocation(parentUri, entity.getId()));
        return new HttpEntity((MultiValueMap)headers);
    }

    @RequestMapping(value={"updatePassword"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updatePassword(@RequestBody IChangePasswordParams changePasswordParams) {
        User user = (User)this.database.findById(User.class, changePasswordParams.getId(), new Initializer[0]);
        if (changePasswordParams.getNewPassword().length() < this.minimalPasswordLength) {
            throw new RestProcessingException(new String[]{"password_too_short"});
        }
        if (!changePasswordParams.getNewPassword().equals(changePasswordParams.getConfirmationPassword())) {
            throw new RestProcessingException(new String[]{"password_confirmation_not_match"});
        }
        user.setPassword(SecurityUtil.passwordHash((String)changePasswordParams.getNewPassword()));
        user.setLastPasswordChangeTime(new Date());
        this.database.update((AbstractEntity)user);
    }

    @RequestMapping(value={"updateOwnPassword"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateOwnPassword(@RequestBody IChangePasswordParams changePasswordParams) {
        if (!this.sessionState.getUser().getPassword().equals(SecurityUtil.passwordHash((String)changePasswordParams.getActualPassword()))) {
            throw new RestProcessingException(new String[]{"wrong_password"});
        }
        changePasswordParams.setId(this.sessionState.getUser().getId());
        this.updatePassword(changePasswordParams);
    }

    @RequestMapping(value={"blockUser"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void blockUser(@RequestBody IBlockUserParams blockParams) {
        User user = (User)this.database.findById(User.class, blockParams.getId(), new Initializer[0]);
        user.setBlocked(blockParams.getBlock());
        this.database.update((AbstractEntity)user);
    }

    @Override
    @RequestMapping(method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void update(@RequestBody User entity) {
        User user = (User)this.database.findById(User.class, entity.getId(), new Initializer[0]);
        entity.setPassword(user.getPassword());
        this.database.update((AbstractEntity)entity.getPerson());
        this.database.update((AbstractEntity)entity);
    }
}

