/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.scope;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.NamedThreadLocal;
import org.springframework.web.context.request.AbstractRequestAttributesScope;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class WideSessionScope
extends AbstractRequestAttributesScope
implements Scope {
    private static final Logger log = LoggerFactory.getLogger(WideSessionScope.class);
    protected Map<String, ThreadLocal<Object>> objectHolders = new HashMap<String, ThreadLocal<Object>>();

    protected int getScope() {
        return 13;
    }

    public String getConversationId() {
        try {
            return RequestContextHolder.currentRequestAttributes().getSessionId();
        }
        catch (IllegalStateException e) {
            log.debug("outside web session");
            return "non_web_";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory<?> objectFactory) {
        try {
            Object mutex;
            Object object = mutex = RequestContextHolder.currentRequestAttributes().getSessionMutex();
            synchronized (object) {
                return super.get(name, objectFactory);
            }
        }
        catch (IllegalStateException e) {
            log.debug("outside web session");
            ThreadLocal<Object> objectHolder = this.objectHolders.get(name);
            if (objectHolder == null) {
                this.objectHolders.put(name, (ThreadLocal<Object>)new NamedThreadLocal("wideScopeObjectHolder_" + name));
                objectHolder = this.objectHolders.get(name);
            }
            if (objectHolder.get() == null) {
                objectHolder.set(objectFactory.getObject());
            }
            return objectHolder.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String name) {
        try {
            Object mutex;
            Object object = mutex = RequestContextHolder.currentRequestAttributes().getSessionMutex();
            synchronized (object) {
                return super.remove(name);
            }
        }
        catch (IllegalStateException e) {
            log.debug("outside web session");
            Object object = this.objectHolders.get(name).get();
            this.objectHolders.get(name).set(null);
            return object;
        }
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        try {
            log.debug("outside web session");
            RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
            attributes.registerDestructionCallback(name, callback, this.getScope());
        }
        catch (IllegalStateException e) {
            log.debug("outside web session");
        }
    }
}

