/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.controller.organization;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.api.Initializer;
import pl.matsuo.core.model.organization.OrganizationUnit;
import pl.matsuo.core.model.organization.Person;
import pl.matsuo.core.model.organization.initializer.CompanyInitializer;
import pl.matsuo.core.web.controller.AbstractSimpleController;

@RestController
@RequestMapping(value={"/organizationUnits"})
public class OrganizationUnitController
extends AbstractSimpleController<OrganizationUnit> {
    @Override
    protected List<Function<OrganizationUnit, String>> queryMatchers() {
        return Arrays.asList(OrganizationUnit::getFullName);
    }

    @Override
    protected List<? extends Initializer<OrganizationUnit>> entityInitializers() {
        return Arrays.asList(new CompanyInitializer());
    }

    @Override
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public HttpEntity<OrganizationUnit> find(@PathVariable(value="id") Long id) {
        HttpEntity entity = super.find(id);
        ((OrganizationUnit)entity.getBody()).getEmployees().size();
        return entity;
    }

    @RequestMapping(value={"/{id}/employee/{idEmployee}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public Person addEmployee(@PathVariable(value="id") Long id, @PathVariable(value="idEmployee") Long idEmployee) {
        Person person = (Person)this.database.findById(Person.class, idEmployee, new Initializer[0]);
        OrganizationUnit organizationUnit = (OrganizationUnit)this.database.findById(OrganizationUnit.class, id, this.entityInitializers);
        organizationUnit.getEmployees().add(person);
        this.database.update((AbstractEntity)organizationUnit);
        return person;
    }

    @RequestMapping(value={"/{id}/employee/{idEmployee}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void removeEmployee(@PathVariable(value="id") Long id, @PathVariable(value="idEmployee") Long idEmployee) {
        OrganizationUnit organizationUnit = (OrganizationUnit)this.database.findById(OrganizationUnit.class, id, this.entityInitializers);
        Iterator iterator = organizationUnit.getEmployees().iterator();
        while (iterator.hasNext()) {
            Person person = (Person)iterator.next();
            if (!person.getId().equals(idEmployee)) continue;
            iterator.remove();
        }
        this.database.update((AbstractEntity)organizationUnit);
    }
}

