/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.mvc;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import pl.matsuo.core.params.IRequestParams;
import pl.matsuo.core.service.facade.FacadeBuilder;
import pl.matsuo.core.service.parameterprovider.IParameterProvider;
import pl.matsuo.core.service.parameterprovider.MapParameterProvider;

@Component
public class FacadeBuilderHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Autowired
    FacadeBuilder facadeBuilder;
    protected Gson gson = new Gson();

    public boolean supportsParameter(MethodParameter parameter) {
        return IRequestParams.class.isAssignableFrom(parameter.getParameterType()) || IParameterProvider.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Object facade;
        boolean returnFacade = IRequestParams.class.isAssignableFrom(parameter.getParameterType());
        if (parameter.hasParameterAnnotation(RequestBody.class)) {
            String body = IOUtils.toString((InputStream)((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)).getInputStream());
            facade = returnFacade ? this.facadeBuilder.createFacade(this.gson.fromJson(body, new TypeToken<Map<String, Object>>(){}.getType()), parameter.getParameterType()) : this.facadeBuilder.createParameterProvider(this.gson.fromJson(body, new TypeToken<Map<String, Object>>(){}.getType()));
        } else {
            Map parameterMap = webRequest.getParameterMap();
            HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
            for (String key : parameterMap.keySet()) {
                String[] values = (String[])parameterMap.get(key);
                params.put(key, new ArrayList<String>(Arrays.asList(values)));
            }
            MapParameterProvider parameterProvider = new MapParameterProvider(params){

                public Object internalGet(String key, Class<?> expectedClass) {
                    if (expectedClass.equals(List.class)) {
                        return super.internalGet(key, expectedClass);
                    }
                    Object list = super.internalGet(key, Object.class);
                    if (list == null) {
                        return null;
                    }
                    if (List.class.isAssignableFrom(list.getClass())) {
                        return ((List)list).get(0);
                    }
                    return list;
                }
            };
            facade = returnFacade ? this.facadeBuilder.createFacade((Object)parameterProvider, parameter.getParameterType()) : parameterProvider;
        }
        String name = Conventions.getVariableNameForParameter((MethodParameter)parameter);
        WebDataBinder binder = binderFactory.createBinder(webRequest, facade, name);
        this.validate(binder, parameter);
        mavContainer.addAttribute(BindingResult.MODEL_KEY_PREFIX + name, (Object)binder.getBindingResult());
        return facade;
    }

    private void validate(WebDataBinder binder, MethodParameter parameter) throws Exception {
        Annotation[] annotations;
        for (Annotation annot : annotations = parameter.getParameterAnnotations()) {
            Object[] objectArray;
            if (!annot.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object hints = AnnotationUtils.getValue((Annotation)annot);
            if (hints instanceof Object[]) {
                objectArray = (Object[])hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            binder.validate(objectArray);
            BindingResult bindingResult = binder.getBindingResult();
            if (!bindingResult.hasErrors() || !this.isBindExceptionRequired(binder, parameter)) break;
            throw new MethodArgumentNotValidException(parameter, bindingResult);
        }
    }

    private boolean isBindExceptionRequired(WebDataBinder binder, MethodParameter parameter) {
        int i = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getMethod().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
        return !hasBindingResult;
    }
}

