/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.web.view;

import com.google.common.base.Joiner;
import j2html.TagCreator;
import j2html.attributes.Attr;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.Tag;
import j2html.tags.specialized.InputTag;
import j2html.tags.specialized.LabelTag;
import j2html.tags.specialized.OptionTag;
import j2html.tags.specialized.SelectTag;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import pl.matsuo.core.model.validation.EntityReference;
import pl.matsuo.core.model.validation.PasswordField;
import pl.matsuo.core.util.ArrayUtil;
import pl.matsuo.core.util.ReflectUtil;

@Component
public class BootstrapRenderer {
    private static final Logger log = LoggerFactory.getLogger(BootstrapRenderer.class);
    private static BootstrapRenderer bootstrapRenderer;
    Validator validator;

    @PostConstruct
    public void init() {
        if (bootstrapRenderer != null) {
            log.error("Second spring bean BootstrapRenderer");
        }
        bootstrapRenderer = this;
        this.validator = Validation.buildDefaultValidatorFactory().getValidator();
    }

    protected String renderField(Class<?> fieldType, AnnotatedElement annotatedElement, String fieldName, BootstrapRenderingBuilder builder) {
        String fullFieldName = this.fullFieldName(builder.entityName, fieldName);
        return this.createControlGroup(fullFieldName, this.createControls(fieldType, annotatedElement, fieldName, builder.entityType, fullFieldName, builder, (String[])ArrayUtils.addAll((Object[])builder.cssClasses, (Object[])new String[]{this.lastNameElement(fieldName.split("[.]"))})));
    }

    private String createControlGroup(String fullFieldName, ContainerTag controls) {
        return TagCreator.div((Attr.ShortForm)this.attrs(Arrays.asList("form-group", fullFieldName.replaceAll("[.-]", "_"), this.bindServerErrorPath(fullFieldName, " && 'error' || ''")).toString()), (DomContent[])new DomContent[]{((LabelTag)TagCreator.label((Attr.ShortForm)this.attrs(".col-sm-4.control-label")).attr("for", (Object)fullFieldName)).attr("translate", (Object)fullFieldName), controls}).renderFormatted();
    }

    private String serverErrorPath(String fullFieldName) {
        return this.formField(fullFieldName, "serverError");
    }

    private String bindServerErrorPath(String fullFieldName, String suffix) {
        return "{{" + this.formField(fullFieldName, "serverError") + suffix + "}}";
    }

    private String formField(String fullFieldName, String field) {
        return this.joinDot("form", fullFieldName.replaceAll("[.-]", "_"), field);
    }

    private String joinDot(String ... parts) {
        return Joiner.on((String)".").join((Object[])parts);
    }

    private Attr.ShortForm attrs(String ... parts) {
        return TagCreator.attrs((String)("." + Joiner.on((String)".").join((Object[])parts)));
    }

    private ContainerTag createControls(Class<?> fieldType, AnnotatedElement annotatedElement, String fieldName, Class<?> entityType, String fullFieldName, BootstrapRenderingBuilder builder, String ... cssClasses) {
        return TagCreator.div((Attr.ShortForm)this.attrs("col-sm-6", this.isCheckbox(fieldType) ? "checkbox" : ""), (DomContent[])new DomContent[]{this.createInput(fieldType, annotatedElement, fullFieldName, entityType, fieldName, builder, cssClasses), TagCreator.span((Attr.ShortForm)this.attrs("help-inline", this.bindServerErrorPath(fullFieldName, " ? '' : 'hide'")), (DomContent[])new DomContent[]{TagCreator.text((String)this.bindServerErrorPath(fullFieldName, ""))})});
    }

    private String lastNameElement(String[] splitted) {
        String lastNameElement = splitted[splitted.length - 1];
        if (lastNameElement.equals("id")) {
            lastNameElement = lastNameElement + StringUtils.capitalize((String)splitted[splitted.length - 2]);
        }
        return lastNameElement;
    }

    private boolean isCheckbox(Class<?> fieldType) {
        return Boolean.TYPE.isAssignableFrom(fieldType) || Boolean.class.isAssignableFrom(fieldType);
    }

    protected ContainerTag createSelect(String lastNameElement, String constantValues) {
        SelectTag element = TagCreator.select((DomContent[])new DomContent[]{TagCreator.option((DomContent[])new DomContent[]{TagCreator.text((String)lastNameElement)}), TagCreator.option((DomContent[])new DomContent[]{TagCreator.text((String)constantValues)})});
        return element;
    }

    private Tag createInput(Class<?> fieldType, AnnotatedElement annotatedElement, String fullFieldName, Class<?> entityType, String fieldName, BootstrapRenderingBuilder builder, String ... cssClasses) {
        SelectTag el;
        boolean addFormControlStyle = true;
        SelectTag inputIfNotEl = null;
        String ngModel = fullFieldName;
        if (Enum.class.isAssignableFrom(fieldType)) {
            el = TagCreator.select((DomContent[])this.getEnumValuesElements(fieldType, !this.isAnnotationPresent(annotatedElement, NotNull.class)));
        } else if (Time.class.isAssignableFrom(fieldType)) {
            el = ((InputTag)TagCreator.input((Attr.ShortForm)this.attrs(".input-size-time.timepicker")).attr("type", (Object)"text")).attr("placeholder", (Object)"HH:mm");
            this.pattern((Tag)el, "[0-2][0-9]:[0-5][0-9]");
        } else if (Date.class.isAssignableFrom(fieldType)) {
            el = ((InputTag)TagCreator.input((Attr.ShortForm)this.attrs(".input-size-date")).attr("type", (Object)"text")).attr("mt-datepicker", (Object)"datepickerOptions");
        } else if (this.isAnnotationPresent(annotatedElement, ManyToOne.class, EntityReference.class, OneToOne.class)) {
            String[] splitted = fullFieldName.split("[.]");
            String lastNameElement = this.lastNameElement(splitted);
            el = this.createSelect(lastNameElement, "$select.elements");
            if (fieldType.equals(Integer.class)) {
                ngModel = this.joinDot(lastNameElement, "value");
            }
            addFormControlStyle = false;
        } else if (this.isCheckbox(fieldType)) {
            inputIfNotEl = TagCreator.input().attr("type", (Object)"checkbox");
            el = TagCreator.label((DomContent[])new DomContent[]{inputIfNotEl, TagCreator.text((String)"&nbsp;")});
            addFormControlStyle = false;
        } else {
            el = TagCreator.input().attr("type", (Object)"text");
            if (Number.class.isAssignableFrom(fieldType)) {
                this.pattern((Tag)el, "[0-9]+([.,][0-9]+)?");
            }
            if (this.isAnnotationPresent(annotatedElement, PasswordField.class)) {
                el.attr("type", (Object)"password");
            }
        }
        this.addFieldValidation(fieldType, entityType, (Tag)el, fieldName);
        SelectTag val = inputIfNotEl != null ? inputIfNotEl : el;
        val.attr("id", (Object)fullFieldName).attr("name", (Object)fullFieldName.replaceAll("\\.", "_")).attr("ng-model", (Object)ngModel).attr("placeholder", (Object)("{{ '" + fullFieldName + "' | translate }}"));
        if (addFormControlStyle) {
            // empty if block
        }
        if (builder != null) {
            for (String attr : builder.attributes.keySet()) {
                val.attr(attr, builder.attributes.get(attr));
            }
        }
        return el;
    }

    private boolean isAnnotationPresent(AnnotatedElement annotatedElement, Class<? extends Annotation> ... annotations) {
        if (annotatedElement != null) {
            for (Class<? extends Annotation> annotation : annotations) {
                if (!annotatedElement.isAnnotationPresent(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    private void addFieldValidation(Class<?> fieldType, Class<?> entityType, Tag el, String fieldName) {
        BeanDescriptor constraintsForClass;
        PropertyDescriptor constraintsForProperty;
        if (entityType == null) {
            return;
        }
        String propertyName = fieldName.substring(fieldName.lastIndexOf(".") + 1);
        if (fieldName.contains(".")) {
            entityType = ReflectUtil.getPropertyType(entityType, (String)fieldName.substring(0, fieldName.lastIndexOf(".")));
        }
        if ((constraintsForProperty = (constraintsForClass = this.validator.getConstraintsForClass(entityType)).getConstraintsForProperty(propertyName)) != null) {
            Set constraintDescriptors = constraintsForProperty.getConstraintDescriptors();
            for (ConstraintDescriptor constraintDescriptor : constraintDescriptors) {
                Pattern pattern;
                Annotation annotation = constraintDescriptor.getAnnotation();
                if (NotNull.class.isAssignableFrom(annotation.getClass())) {
                    el.attr("required", null);
                    continue;
                }
                if (Pattern.class.isAssignableFrom(annotation.getClass())) {
                    pattern = (Pattern)annotation;
                    this.pattern(el, pattern.regexp());
                    continue;
                }
                if (Digits.class.isAssignableFrom(annotation.getClass())) {
                    Digits digits = (Digits)annotation;
                    this.pattern(el, "[0-9]{" + digits.integer() + "}([.,][0-9]{" + digits.fraction() + "})?");
                    continue;
                }
                if (this.isAnnotatedAnnotation(annotation.getClass(), Pattern.class) == null) continue;
                pattern = this.isAnnotatedAnnotation(annotation.getClass(), Pattern.class);
                this.pattern(el, pattern.regexp());
            }
        }
    }

    private <A extends Annotation> A isAnnotatedAnnotation(Class<?> clazz, Class<A> annotation) {
        if (clazz.getAnnotation(annotation) != null) {
            return annotation.getClass().getAnnotation(annotation);
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (iface.getAnnotation(annotation) == null) continue;
            return iface.getAnnotation(annotation);
        }
        return null;
    }

    private void pattern(Tag el, String pattern) {
        el.attr("ng-pattern", (Object)("/^(" + pattern + ")?$/"));
    }

    private ContainerTag[] getEnumValuesElements(Class<? extends Enum<?>> propertyType, boolean withEmptyElement) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (withEmptyElement) {
            elements.add(TagCreator.option());
        }
        for (Enum<?> enumElement : propertyType.getEnumConstants()) {
            elements.add((ContainerTag)((OptionTag)TagCreator.option().attr("translate", (Object)this.joinDot("enum", propertyType.getSimpleName(), enumElement.toString()))).attr("value", (Object)enumElement.name()));
        }
        return elements.toArray(new ContainerTag[0]);
    }

    public BootstrapRenderingBuilder create(Class<?> entityType) {
        return new BootstrapRenderingBuilder(entityType);
    }

    private String renderInlineFields(String[] fields, BootstrapRenderingBuilder builder) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (String fieldName : fields) {
            String fullFieldName = this.fullFieldName(builder.entityName, fieldName);
            String simpleElementName = (String)ArrayUtil.last((Object[])fieldName.split("[.]"));
            elements.add(TagCreator.span((Attr.ShortForm)this.attrs(".inline-form-text." + simpleElementName)).attr("translate", (Object)fullFieldName));
            elements.add(this.createInput(ReflectUtil.getPropertyType((Class)builder.entityType, (String)fieldName), ReflectUtil.getAnnotatedElement((Class)builder.entityType, (String)fieldName), fullFieldName, builder.entityType, "entity", builder, simpleElementName));
        }
        elements.remove(0);
        elements.add(TagCreator.span((Attr.ShortForm)this.attrs(".help-inline"), (DomContent[])new DomContent[]{TagCreator.text((String)this.bindServerErrorPath(builder.entityName, ""))}));
        return this.createControlGroup(this.fullFieldName(builder.entityName, fields[0]), (ContainerTag)TagCreator.div((Attr.ShortForm)this.attrs(".controls"), (DomContent[])((DomContent[])elements.toArray(new Tag[0]))));
    }

    public String renderSingleField(Class<?> fieldType, String fieldName, String ... cssClasses) {
        return this.renderField(fieldType, null, fieldName, this.create(null).cssClasses(cssClasses)) + "\n";
    }

    public String renderSingleField(Method method, String fieldName, String ... cssClasses) {
        return this.renderField(method.getReturnType(), method, fieldName, this.create(null).cssClasses(cssClasses)) + "\n";
    }

    private String fullFieldName(String entityName, String fieldName) {
        return (entityName != null ? Introspector.decapitalize(entityName) + "." : "") + fieldName;
    }

    public static BootstrapRenderer renderer() {
        return bootstrapRenderer;
    }

    public static class BootstrapRenderingBuilder {
        private Class<?> entityType;
        private String entityName = "entity";
        private boolean inline = false;
        private String[] cssClasses;
        private Map<String, String> attributes = new HashMap<String, String>();

        public BootstrapRenderingBuilder(Class<?> entityType) {
            this.entityType = entityType;
        }

        public BootstrapRenderingBuilder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public BootstrapRenderingBuilder inline(boolean inline) {
            this.inline = inline;
            return this;
        }

        public BootstrapRenderingBuilder cssClasses(String ... cssClasses) {
            this.cssClasses = cssClasses;
            return this;
        }

        public BootstrapRenderingBuilder attribute(String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        public String render(String ... fields) {
            if (this.inline) {
                return BootstrapRenderer.renderer().renderInlineFields(fields, this);
            }
            return Arrays.asList(fields).stream().reduce("", (sum, fieldName) -> sum + BootstrapRenderer.renderer().renderField(ReflectUtil.getPropertyType(this.entityType, (String)fieldName), ReflectUtil.getAnnotatedElement(this.entityType, (String)fieldName), (String)fieldName, this) + "\n");
        }

        public String renderWithName(String entityFieldName, String htmlFieldName) {
            return BootstrapRenderer.renderer().renderField(ReflectUtil.getPropertyType(this.entityType, (String)entityFieldName), ReflectUtil.getAnnotatedElement(this.entityType, (String)entityFieldName), htmlFieldName, this);
        }
    }
}

