/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.tools.kafka.gui.view;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.TopicListing;
import org.junit.Test;
import pl.matsuo.core.util.desktop.IRequest;
import pl.matsuo.core.util.desktop.ViewTestUtil;
import pl.matsuo.core.util.desktop.component.FormComponents;
import pl.matsuo.core.util.desktop.component.ViewComponents;
import pl.matsuo.tools.kafka.gui.model.KafkaAdminGuiModel;
import pl.matsuo.tools.kafka.gui.model.KafkaInstanceModel;
import pl.matsuo.tools.kafka.gui.view.KafkaInstancesListView;

public class TestKafkaInstancesListView {
    ViewComponents viewComponents = new ViewComponents();
    FormComponents formComponents = new FormComponents();

    @Test
    public void viewNoForm() {
        KafkaInstancesListView view = new KafkaInstancesListView(this.viewComponents, this.formComponents);
        KafkaAdminGuiModel model = new KafkaAdminGuiModel();
        HashMap<String, TopicListing> topicListingMap = new HashMap<String, TopicListing>();
        topicListingMap.put("topic", new TopicListing("topic", false));
        model.setTopics(topicListingMap);
        model.setKafkaInstance(new KafkaInstanceModel("test", "localhost:9092"));
        model.getKnownInstances().add(model.getKafkaInstance());
        String rendered = view.view(IRequest.request((String)"/kafkaInstancesList", Collections.emptyMap()), model).renderFormatted();
        ViewTestUtil.storeView((String)"kafkaInstancesList.html", (String)rendered);
    }

    @Test
    public void viewWithForm() {
        KafkaInstancesListView view = new KafkaInstancesListView(this.viewComponents, this.formComponents);
        KafkaAdminGuiModel model = new KafkaAdminGuiModel();
        HashMap<String, TopicListing> topicListingMap = new HashMap<String, TopicListing>();
        topicListingMap.put("topic", new TopicListing("topic", false));
        model.setTopics(topicListingMap);
        model.setKafkaInstance(new KafkaInstanceModel("Localhost 9092", "localhost:9092", Integer.valueOf(7)));
        model.getKnownInstances().add(model.getKafkaInstance());
        model.getKnownInstances().add(new KafkaInstanceModel("Very far", "ohio.com:9092", Integer.valueOf(12)));
        model.getKnownInstances().add(new KafkaInstanceModel("Not so far", "kaszuby.pl:9092"));
        String rendered = view.view(IRequest.request((String)"/kafkaInstancesListWithForm", (Map)ImmutableMap.builder().put((Object)"showAddForm", (Object)"true").build()), model).renderFormatted();
        ViewTestUtil.storeView((String)"kafkaInstancesListWithForm.html", (String)rendered);
    }
}

