/*
 * Decompiled with CFR 0.152.
 */
package pl.metastack.metaweb;

import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class HtmlHelpers$ {
    public static final HtmlHelpers$ MODULE$;
    private final Set<String> VoidElements;

    static {
        new HtmlHelpers$();
    }

    public Set<String> VoidElements() {
        return this.VoidElements;
    }

    public String escapeAttribute(String value) {
        return value.replaceAll("\"", "&quot;");
    }

    public String quoteAttribute(String value) {
        return new StringBuilder().append((Object)"\"").append((Object)this.escapeAttribute(value)).append((Object)"\"").toString();
    }

    public String escape(String text) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(text)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(char x0$1) {
                String string;
                char c = x0$1;
                switch (c) {
                    default: {
                        if (c >= ' ') {
                            string = Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToCharacter((char)c)).toString());
                            break;
                        }
                        string = Predef$.MODULE$.augmentString("");
                        break;
                    }
                    case '\t': {
                        string = Predef$.MODULE$.augmentString("\t");
                        break;
                    }
                    case '\r': {
                        string = Predef$.MODULE$.augmentString("\r");
                        break;
                    }
                    case '\n': {
                        string = Predef$.MODULE$.augmentString("\n");
                        break;
                    }
                    case '\"': {
                        string = Predef$.MODULE$.augmentString("&quot;");
                        break;
                    }
                    case '&': {
                        string = Predef$.MODULE$.augmentString("&amp;");
                        break;
                    }
                    case '>': {
                        string = Predef$.MODULE$.augmentString("&gt;");
                        break;
                    }
                    case '<': {
                        string = Predef$.MODULE$.augmentString("&lt;");
                    }
                }
                return string;
            }
        }, Predef$.MODULE$.StringCanBuildFrom());
    }

    public String encodedAttributes(Map<String, Object> attributes) {
        return ((TraversableOnce)attributes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    String string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}))).append((Object)HtmlHelpers$.MODULE$.quoteAttribute(value.toString())).toString();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(" ");
    }

    public String node(String tagName, Map<String, Object> attributes, Seq<String> contents) {
        String string;
        String attrs;
        String string2 = attrs = attributes.isEmpty() ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.encodedAttributes(attributes)}));
        if (this.VoidElements().contains((Object)tagName) && contents.isEmpty()) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<", "", "/>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tagName, attrs}));
        } else {
            String string3 = tagName;
            String string4 = "html";
            String docType = !(string3 != null ? !string3.equals(string4) : string4 != null) ? "<!DOCTYPE html>" : "";
            String children = contents.mkString();
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "<", "", ">", "</", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{docType, tagName, attrs, children, tagName}));
        }
        return string;
    }

    private HtmlHelpers$() {
        MODULE$ = this;
        this.VoidElements = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"}));
    }
}

