package pl.metastack.metaweb.tag

import pl.metastack.metaweb.tree

/**
 * The HTML Center Element (<code>&lt;center&gt;</code>) is a <a href="/en-US/docs/HTML/Block-level_elements" title="HTML/Block-level_elements">block-level element</a> that can contain paragraphs and other block-level and inline elements. The entire content of this element is centered horizontally within its containing element (typically, the <a href="/en-US/docs/Web/HTML/Element/body" title="The HTML Body Element (<body>) represents the content of an HTML&nbsp;document. There can be only one <body> element in a document."><code>&lt;body&gt;</code></a>).
This tag has been deprecated in HTML 4 (and XHTML 1) in favor of the <a href="/en-US/docs/Web/CSS" title="/en-US/docs/Web/CSS">CSS</a> <a href="/en-US/docs/Web/CSS/text-align" title="The text-align CSS property describes how inline content like text is aligned in its parent block element. text-align does not control the alignment of block elements itself, only their inline content."><code>text-align</code></a> property, which can be applied to the <a href="/en-US/docs/Web/HTML/Element/div" title="The HTML <div> element (or HTML Document Division Element) is the generic container for flow content, which does not inherently represent anything. It can be used to group elements for styling purposes (using the class or id attributes), or because they share attribute values, such as lang. It should be used only when no other semantic element (such as <article> or <nav>) is appropriate."><code>&lt;div&gt;</code></a> element or to an individual <a href="/en-US/docs/Web/HTML/Element/p" title="The HTML <p> element (or HTML Paragraph Element) represents a paragraph of text."><code>&lt;p&gt;</code></a>. For centering blocks, use other CSS properties like <a href="/en-US/docs/Web/CSS/margin-left" title="The margin-left CSS property of an element sets the margin space required on the left side of a box associated with an element. A negative value is also allowed."><code>margin-left</code></a> and <a href="/en-US/docs/Web/CSS/margin-right" title="The margin-right CSS property of an element sets the margin space required on the right side of an element. A negative value is also allowed."><code>margin-right</code></a> and set them to <code>auto</code> (or set <a href="/en-US/docs/Web/CSS/margin" title="The margin CSS property sets the margin for all four sides. It is a shorthand to avoid setting each side separately with the other margin properties: margin-top, margin-right, margin-bottom and margin-left."><code>margin</code></a> to <code>0 auto</code>).
 */
case class Center(attributes: Predef.Map[String, Any] = Predef.Map.empty, children: Seq[tree.Node] = Seq.empty) extends HTMLTag[Center] {
  override def tagName = "center"
  override def copy(attributes: Predef.Map[String, Any] = attributes, children: Seq[tree.Node] = children): Center = Center(attributes, children)
}
