package pl.metastack.metaweb.tag

import pl.metastack.metaweb.tree

/**
 * The <strong>HTML <code>&lt;hgroup&gt;</code> Element</strong> (<em>HTML Headings Group Element</em>) represents the heading of a section. It defines a single title that participates in <a href="/en-US/docs/Sections_and_Outlines_of_an_HTML5_document" title="Sections and Outlines of an HTML5 document">the outline of the document</a> as the heading of the implicit or explicit section that it belongs to.
Its <em>text</em> for the outline algorithm is the text of the first HTML Heading Element of highest rank (i.e., the first <a href="/en-US/docs/Web/HTML/Element/h1" title="Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."><code>&lt;h1&gt;</code></a>, <a href="/en-US/docs/Web/HTML/Element/h2" title="Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."><code>&lt;h2&gt;</code></a>, <a href="/en-US/docs/Web/HTML/Element/h3" title="Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."><code>&lt;h3&gt;</code></a>, <a href="/en-US/docs/Web/HTML/Element/h4" title="REDIRECT Heading elements [en-US]"><code>&lt;h4&gt;</code></a>, <a href="/en-US/docs/Web/HTML/Element/h5" title="Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."><code>&lt;h5&gt;</code></a> or <a href="/en-US/docs/Web/HTML/Element/h6" title="Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."><code>&lt;h6&gt;</code></a> with the smallest number among its descendants) and the <em>rank</em> is the rank of this very same HTML Heading Element.
Therefore this element groups several headings, contributing only the main one to the outline of the document. It allows associating secondary titles, like subheadings, alternative titles, or even taglines, with the main heading, without polluting the outline of the document.
 */
case class Hgroup(attributes: Predef.Map[String, Any] = Predef.Map.empty, children: Seq[tree.Node] = Seq.empty) extends HTMLTag[Hgroup] {
  override def tagName = "hgroup"
  override def copy(attributes: Predef.Map[String, Any] = attributes, children: Seq[tree.Node] = children): Hgroup = Hgroup(attributes, children)
}
