/*
 * Decompiled with CFR 0.152.
 */
package pl.michal.grzesiak.criticizer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Stream;
import javax.validation.Constraint;
import pl.michal.grzesiak.criticizer.ChildFieldsExtractor;

public class ValidationAnnotationChecker {
    private final ChildFieldsExtractor childFieldsExtractor;

    public ValidationAnnotationChecker(ChildFieldsExtractor childFieldsExtractor) {
        this.childFieldsExtractor = childFieldsExtractor;
    }

    public boolean hasAnyChildValidationAnnotation(Field parent) {
        List<Field> children = this.childFieldsExtractor.getFieldsFrom(parent);
        return children.stream().anyMatch(this::hasChildAnyValidation);
    }

    private boolean hasChildAnyValidation(Field field) {
        Annotation[] annotationsOnField = field.getAnnotations();
        return Stream.of(annotationsOnField).map(Annotation::annotationType).map(Class::getDeclaredAnnotations).anyMatch(annotations -> Stream.of(annotations).anyMatch(annotation -> annotation.annotationType().equals(Constraint.class)));
    }
}

